/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.soap;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.zalando.fauxpas.FauxPas;

public final class SOAPHttpMessageConverter
extends AbstractHttpMessageConverter<Object> {
    private final LoadingCache<Class<?>, JAXBContext> contexts = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, JAXBContext>(){

        public JAXBContext load(Class<?> type) throws Exception {
            return JAXBContext.newInstance((Class[])new Class[]{type});
        }
    });
    private final ThreadLocal<MessageFactory> messageFactory;
    private final DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();

    public SOAPHttpMessageConverter() {
        this("SOAP 1.1 Protocol");
    }

    public SOAPHttpMessageConverter(String protocol) {
        super(MediaType.TEXT_XML);
        this.messageFactory = ThreadLocal.withInitial(FauxPas.throwingSupplier(() -> MessageFactory.newInstance((String)protocol)));
    }

    protected boolean supports(Class<?> type) {
        return type.isAnnotationPresent(XmlRootElement.class) || type.isAnnotationPresent(XmlType.class);
    }

    @Nonnull
    protected Object readInternal(Class<?> type, HttpInputMessage message) throws IOException, HttpMessageNotReadableException {
        try {
            SOAPMessage soapMessage = this.messageFactory.get().createMessage(null, message.getBody());
            Document document = soapMessage.getSOAPBody().extractContentAsDocument();
            Unmarshaller unmarshaller = ((JAXBContext)this.contexts.getUnchecked(type)).createUnmarshaller();
            return unmarshaller.unmarshal((Node)document);
        }
        catch (JAXBException | SOAPException e) {
            throw new HttpMessageNotReadableException(e.getMessage(), e, message);
        }
    }

    protected void writeInternal(Object value, HttpOutputMessage message) throws IOException, HttpMessageNotWritableException {
        try {
            Document document = this.builderFactory.newDocumentBuilder().newDocument();
            Marshaller marshaller = ((JAXBContext)this.contexts.getUnchecked(value.getClass())).createMarshaller();
            marshaller.marshal(value, (Node)document);
            SOAPMessage soapMessage = this.messageFactory.get().createMessage();
            soapMessage.getSOAPBody().addDocument(document);
            soapMessage.writeTo(message.getBody());
        }
        catch (JAXBException | SOAPException | ParserConfigurationException e) {
            throw new HttpMessageNotWritableException(e.getMessage(), e);
        }
    }
}

