/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.stream;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.zalando.riptide.stream.StreamFilter;
import org.zalando.riptide.stream.StreamSpliterator;
import org.zalando.riptide.stream.Streams;

final class StreamConverter<T>
implements GenericHttpMessageConverter<T> {
    private static final List<MediaType> DEFAULT_MEDIA_TYPES = Collections.unmodifiableList(Arrays.asList(Streams.APPLICATION_JSON_SEQ, Streams.APPLICATION_X_JSON_STREAM));
    private final ObjectMapper mapper;
    private final List<MediaType> medias;

    public StreamConverter() {
        this(null, null);
    }

    public StreamConverter(@Nullable ObjectMapper mapper, @Nullable List<MediaType> medias) {
        this.mapper = mapper != null ? mapper : Jackson2ObjectMapperBuilder.json().build();
        this.medias = medias != null ? medias : DEFAULT_MEDIA_TYPES;
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return this.canRead(clazz, null, mediaType);
    }

    private JavaType getJavaType(Type type, @Nullable Class<?> contextClass) {
        TypeFactory tf = this.mapper.getTypeFactory();
        return contextClass != null ? tf.constructType(type, contextClass) : tf.constructType(type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canRead(@Nullable MediaType mediaType) {
        if (mediaType == null) return true;
        if (!this.getSupportedMediaTypes().stream().anyMatch(arg_0 -> ((MediaType)mediaType).isCompatibleWith(arg_0))) return false;
        return true;
    }

    public boolean canRead(Type type, @Nullable Class<?> contextClass, MediaType mediaType) {
        JavaType javaType = this.getJavaType(type, contextClass);
        if (Stream.class.isAssignableFrom(javaType.getRawClass())) {
            JavaType containedType = javaType.containedType(0);
            return containedType != null && this.mapper.canDeserialize(containedType) && this.canRead(mediaType);
        }
        return this.mapper.canDeserialize(javaType) && this.canRead(mediaType);
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return false;
    }

    public boolean canWrite(Type type, Class<?> clazz, MediaType mediaType) {
        return false;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.medias;
    }

    public T read(Class<? extends T> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        JavaType javaType = this.getJavaType(clazz, null);
        return this.read(javaType, inputMessage);
    }

    public T read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        JavaType javaType = this.getJavaType(type, contextClass);
        return this.read(javaType, inputMessage);
    }

    private T read(JavaType javaType, HttpInputMessage inputMessage) {
        try {
            if (Stream.class.isAssignableFrom(javaType.getRawClass())) {
                return this.stream(javaType.containedType(0), this.input(inputMessage));
            }
            return (T)this.mapper.readValue(inputMessage.getBody(), javaType);
        }
        catch (IOException ex) {
            throw new HttpMessageNotReadableException("Could not read document: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private T stream(JavaType javaType, InputStream stream) throws IOException {
        JsonParser parser = this.mapper.getFactory().createParser(stream);
        StreamSpliterator split = new StreamSpliterator(javaType, parser);
        return (T)StreamSupport.stream(split, false).onClose(() -> {
            try {
                parser.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private InputStream input(HttpInputMessage inputMessage) throws IOException {
        MediaType contentType = inputMessage.getHeaders().getContentType();
        boolean sequence = Streams.APPLICATION_JSON_SEQ.includes(contentType);
        return sequence ? new StreamFilter(inputMessage.getBody()) : inputMessage.getBody();
    }

    public void write(T t, MediaType mediaType, HttpOutputMessage message) {
        throw new UnsupportedOperationException();
    }

    public void write(T t, Type type, MediaType mediaType, HttpOutputMessage message) {
        throw new UnsupportedOperationException();
    }
}

