/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.stream;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.zalando.fauxpas.ThrowingConsumer;
import org.zalando.riptide.stream.StreamConverter;

public final class Streams {
    public static final MediaType APPLICATION_X_JSON_STREAM = new MediaType("application", "x-json-stream", StandardCharsets.UTF_8);
    public static final MediaType APPLICATION_JSON_SEQ = new MediaType("application", "json-seq", StandardCharsets.UTF_8);

    public static <T> TypeToken<Stream<T>> streamOf(Class<T> type) {
        return Streams.streamOf(TypeToken.of(type));
    }

    public static <T> TypeToken<Stream<T>> streamOf(TypeToken<T> type) {
        TypeToken streamType = new TypeToken<Stream<T>>(){};
        TypeParameter elementType = new TypeParameter<T>(){};
        return streamType.where(elementType, type);
    }

    public static <I, X extends Throwable> ThrowingConsumer<Stream<I>, X> forEach(ThrowingConsumer<I, X> consumer) {
        return input -> {
            if (input == null) {
                return;
            }
            try {
                input.forEach(consumer);
            }
            finally {
                input.close();
            }
        };
    }

    @Deprecated
    public static HttpMessageConverter<?> streamConverter() {
        return Streams.streamConverter(new ObjectMapper());
    }

    public static HttpMessageConverter<?> streamConverter(ObjectMapper mapper) {
        return Streams.streamConverter(mapper, Arrays.asList(APPLICATION_JSON_SEQ, APPLICATION_X_JSON_STREAM));
    }

    public static HttpMessageConverter<?> streamConverter(ObjectMapper mapper, List<MediaType> supportedMediaTypes) {
        return new StreamConverter(mapper, supportedMediaTypes);
    }
}

