/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.stream;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

final class StreamFilter
extends FilterInputStream {
    private static final int JSON_SEQUENCE_RECORD_SEPARATOR = 30;
    final int size;

    protected StreamFilter(InputStream in) {
        this(in, 8192);
    }

    protected StreamFilter(InputStream in, int size) {
        super(in);
        this.size = size;
    }

    private boolean filtered(byte read) {
        return read == 30;
    }

    @Override
    public int read() throws IOException {
        int read;
        do {
            if ((read = super.read()) != -1) continue;
            return -1;
        } while (this.filtered((byte)read));
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int index;
        int read = super.read(b, off, len);
        if (read == -1) {
            return -1;
        }
        int until = off + read;
        int last = off;
        for (index = off; index < until; ++index) {
            if (this.filtered(b[index])) continue;
            if (index != last) {
                b[last] = b[index];
            }
            ++last;
        }
        for (index = last; index < until; ++index) {
            b[index] = 0;
        }
        return last - off;
    }

    @Override
    public long skip(long n) throws IOException {
        long sum;
        int read;
        byte[] b = new byte[this.size];
        for (sum = 0L; sum < n; sum += (long)read) {
            int left = (int)(n - sum);
            int len = left > this.size ? this.size : left;
            read = this.read(b, 0, len);
            if (read != -1) continue;
            return sum;
        }
        return sum;
    }
}

