/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.stream;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.zalando.fauxpas.FauxPas;
import org.zalando.riptide.stream.StreamFilter;
import org.zalando.riptide.stream.StreamSpliterator;
import org.zalando.riptide.stream.Streams;

final class StreamConverter<T>
implements GenericHttpMessageConverter<Stream<T>> {
    private final ObjectMapper mapper;
    private final List<MediaType> supportedMediaTypes;

    StreamConverter(ObjectMapper mapper, List<MediaType> supportedMediaTypes) {
        this.mapper = mapper;
        this.supportedMediaTypes = supportedMediaTypes;
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return false;
    }

    public boolean canRead(Type type, @Nullable Class<?> contextClass, MediaType mediaType) {
        JavaType javaType = this.getJavaType(type, contextClass);
        if (Stream.class.isAssignableFrom(javaType.getRawClass())) {
            JavaType containedType = javaType.containedType(0);
            return this.mapper.canDeserialize(containedType) && this.canRead(mediaType);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canRead(@Nullable MediaType mediaType) {
        if (mediaType == null) return true;
        if (!this.getSupportedMediaTypes().stream().anyMatch(arg_0 -> ((MediaType)mediaType).isCompatibleWith(arg_0))) return false;
        return true;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return Collections.unmodifiableList(this.supportedMediaTypes);
    }

    public Stream<T> read(Class<? extends Stream<T>> clazz, HttpInputMessage inputMessage) throws HttpMessageNotReadableException {
        throw new UnsupportedOperationException();
    }

    public Stream<T> read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws HttpMessageNotReadableException {
        JavaType javaType = this.getJavaType(type, contextClass);
        return this.read(javaType, inputMessage);
    }

    private JavaType getJavaType(Type type, @Nullable Class<?> contextClass) {
        TypeFactory factory = this.mapper.getTypeFactory();
        return contextClass == null ? factory.constructType(type) : factory.constructType(type, contextClass);
    }

    private Stream<T> read(JavaType javaType, HttpInputMessage inputMessage) {
        try {
            JavaType elementType = javaType.containedType(0);
            InputStream body = this.extractBody(inputMessage);
            return this.stream(elementType, body);
        }
        catch (IOException ex) {
            throw new HttpMessageNotReadableException("Could not read document: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private InputStream extractBody(HttpInputMessage message) throws IOException {
        MediaType contentType = message.getHeaders().getContentType();
        boolean sequence = Streams.APPLICATION_JSON_SEQ.includes(contentType);
        return sequence ? new StreamFilter(message.getBody()) : message.getBody();
    }

    private Stream<T> stream(JavaType elementType, InputStream stream) throws IOException {
        JsonParser parser = this.mapper.getFactory().createParser(stream);
        StreamSpliterator split = new StreamSpliterator(elementType, parser);
        return (Stream)StreamSupport.stream(split, false).onClose((Runnable)FauxPas.throwingRunnable(() -> ((JsonParser)parser).close()));
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return false;
    }

    public boolean canWrite(Type type, Class<?> clazz, MediaType mediaType) {
        return false;
    }

    public void write(Stream<T> t, MediaType mediaType, HttpOutputMessage message) {
        throw new UnsupportedOperationException();
    }

    public void write(Stream<T> t, Type type, MediaType mediaType, HttpOutputMessage message) {
        throw new UnsupportedOperationException();
    }
}

