/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.stream;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.springframework.http.MediaType;
import org.zalando.fauxpas.ThrowingConsumer;
import org.zalando.riptide.stream.StreamConverter;

@API(status=API.Status.STABLE)
public final class Streams {
    public static final MediaType APPLICATION_JSON_SEQ = new MediaType("application", "json-seq");
    public static final MediaType APPLICATION_STREAM_JSON = new MediaType("application", "stream+json");
    public static final MediaType APPLICATION_X_JSON_STREAM = new MediaType("application", "x-json-stream");

    private Streams() {
    }

    public static <T> TypeToken<Stream<T>> streamOf(Class<T> type) {
        return Streams.streamOf(TypeToken.of(type));
    }

    public static <T> TypeToken<Stream<T>> streamOf(TypeToken<T> type) {
        TypeToken streamType = new TypeToken<Stream<T>>(){};
        TypeParameter elementType = new TypeParameter<T>(){};
        return streamType.where(elementType, type);
    }

    public static <I, X extends Throwable> ThrowingConsumer<Stream<I>, X> forEach(ThrowingConsumer<I, X> consumer) {
        return input -> {
            if (input == null) {
                return;
            }
            try {
                input.forEach(consumer);
            }
            finally {
                input.close();
            }
        };
    }

    public static <T> StreamConverter<T> streamConverter() {
        return Streams.streamConverter(new ObjectMapper());
    }

    public static <T> StreamConverter<T> streamConverter(ObjectMapper mapper) {
        return Streams.streamConverter(mapper, Arrays.asList(APPLICATION_JSON_SEQ, APPLICATION_STREAM_JSON, APPLICATION_X_JSON_STREAM));
    }

    public static <T> StreamConverter<T> streamConverter(ObjectMapper mapper, List<MediaType> supportedMediaTypes) {
        return new StreamConverter(mapper, supportedMediaTypes);
    }
}

