/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConverter;
import org.zalando.riptide.Executor;

public final class Binding<A>
implements Executor {
    private final Optional<A> attribute;
    private final Executor executor;

    private Binding(Optional<A> attribute, Executor executor) {
        this.attribute = attribute;
        this.executor = executor;
    }

    Optional<A> getAttribute() {
        return this.attribute;
    }

    @Override
    public Object execute(ClientHttpResponse response, List<HttpMessageConverter<?>> converters) throws IOException {
        return this.executor.execute(response, converters);
    }

    static <A> Binding<A> create(A attribute, Executor executor) {
        return Binding.create(Optional.of(attribute), executor);
    }

    static <A> Binding<A> create(Optional<A> attribute, Executor executor) {
        return new Binding<A>(attribute, executor);
    }
}

