/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import com.google.common.reflect.TypeToken;
import java.util.Optional;
import javax.annotation.Nullable;
import org.springframework.http.client.ClientHttpResponse;

public final class Retriever {
    private final Object value;

    public Retriever(@Nullable Object value) {
        this.value = value;
    }

    public <T> Optional<T> retrieve(Class<T> type) {
        return this.retrieve(TypeToken.of(type));
    }

    public <T> Optional<T> retrieve(TypeToken<T> type) {
        return Optional.ofNullable(this.value).filter(v -> type.isAssignableFrom(v.getClass())).map(v -> {
            Object t = v;
            return t;
        });
    }

    public Optional<ClientHttpResponse> retrieveResponse() {
        return this.retrieve(ClientHttpResponse.class);
    }
}

