/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpMessageConverterExtractor;
import org.springframework.web.client.RestClientException;
import org.zalando.riptide.Binding;
import org.zalando.riptide.BodyConversionException;
import org.zalando.riptide.Capturer;
import org.zalando.riptide.EntityConsumer;
import org.zalando.riptide.EntityFunction;
import org.zalando.riptide.ResponseEntityConsumer;
import org.zalando.riptide.ResponseEntityFunction;

public final class TypedCondition<A, I>
implements Capturer<A> {
    private final A attribute;
    private final TypeToken<I> type;

    public TypedCondition(A attribute, TypeToken<I> type) {
        this.attribute = attribute;
        this.type = type;
    }

    private I convert(ClientHttpResponse response, List<HttpMessageConverter<?>> converters) throws IOException {
        try {
            return (I)new HttpMessageConverterExtractor(this.type.getType(), converters).extractData(response);
        }
        catch (HttpMessageNotReadableException | RestClientException e) {
            throw new BodyConversionException(e);
        }
    }

    private ResponseEntity<I> toResponseEntity(I entity, ClientHttpResponse response) throws IOException {
        return new ResponseEntity(entity, (MultiValueMap)response.getHeaders(), response.getStatusCode());
    }

    public Binding<A> call(EntityConsumer<I> consumer) {
        return Binding.create(this.attribute, (response, converters) -> {
            I entity = this.convert(response, converters);
            consumer.accept(entity);
            return null;
        });
    }

    public Binding<A> call(ResponseEntityConsumer<I> consumer) {
        return Binding.create(this.attribute, (response, converters) -> {
            I entity = this.convert(response, converters);
            consumer.accept(this.toResponseEntity(entity, response));
            return null;
        });
    }

    public Capturer<A> map(EntityFunction<I, ?> function) {
        return () -> Binding.create(this.attribute, (response, converters) -> {
            I entity = this.convert(response, converters);
            return function.apply(entity);
        });
    }

    public Capturer<A> map(ResponseEntityFunction<I, ?> function) {
        return () -> Binding.create(this.attribute, (response, converters) -> {
            I entity = this.convert(response, converters);
            return function.apply(this.toResponseEntity(entity, response));
        });
    }

    @Override
    public Binding<A> capture() {
        return Binding.create(this.attribute, this::convert);
    }
}

