/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

final class BufferingClientHttpResponseWrapper
implements ClientHttpResponse {
    private final ClientHttpResponse response;
    private byte[] body;

    static BufferingClientHttpResponseWrapper buffer(ClientHttpResponse response) throws IOException {
        BufferingClientHttpResponseWrapper wrapper = new BufferingClientHttpResponseWrapper(response);
        wrapper.buffer();
        return wrapper;
    }

    private BufferingClientHttpResponseWrapper(ClientHttpResponse response) {
        this.response = response;
    }

    public HttpStatus getStatusCode() throws IOException {
        return this.response.getStatusCode();
    }

    public int getRawStatusCode() throws IOException {
        return this.response.getRawStatusCode();
    }

    public String getStatusText() throws IOException {
        return this.response.getStatusText();
    }

    public HttpHeaders getHeaders() {
        return this.response.getHeaders();
    }

    public InputStream getBody() throws IOException {
        return this.body == null ? null : new ByteArrayInputStream(this.body);
    }

    public void close() {
        this.response.close();
    }

    private void buffer() throws IOException {
        if (this.response.getBody() != null) {
            this.body = StreamUtils.copyToByteArray((InputStream)this.response.getBody());
        }
    }
}

