/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConverter;
import org.zalando.riptide.Binding;
import org.zalando.riptide.BodyConversionException;
import org.zalando.riptide.Selector;
import org.zalando.riptide.UnsupportedResponseException;

final class Router {
    private static final Optional ANY = Optional.empty();

    Router() {
    }

    final <A> Object route(ClientHttpResponse response, List<HttpMessageConverter<?>> converters, Selector<A> selector, Collection<Binding<A>> bindings) throws IOException {
        Map index;
        Optional<A> attribute = selector.attributeOf(response);
        Optional<Binding<A>> match = selector.select(attribute, index = (Map)bindings.stream().collect(Collectors.toMap(Binding::getAttribute, Function.identity(), this::denyDuplicates, LinkedHashMap::new)));
        if (match.isPresent()) {
            try {
                Binding<A> binding = match.get();
                return binding.execute(response, converters);
            }
            catch (UnsupportedResponseException e) {
                return this.propagateNoMatch(response, converters, attribute, index, e);
            }
            catch (BodyConversionException e) {
                return this.routeNone(response, converters, attribute, index);
            }
        }
        return this.routeNone(response, converters, attribute, index);
    }

    private <A> Binding<A> denyDuplicates(Binding<A> left, Binding<A> right) {
        left.getAttribute().ifPresent(a -> {
            throw new IllegalStateException("Duplicate condition attribute: " + a);
        });
        throw new IllegalStateException("Duplicate any conditions");
    }

    private <A> Object propagateNoMatch(ClientHttpResponse response, List<HttpMessageConverter<?>> converters, Optional<A> attribute, Map<Optional<A>, Binding<A>> index, UnsupportedResponseException e) throws IOException {
        try {
            return this.routeNone(response, converters, attribute, index);
        }
        catch (UnsupportedResponseException ignored) {
            throw e;
        }
    }

    private <A> Object routeNone(ClientHttpResponse response, List<HttpMessageConverter<?>> converters, Optional<A> attribute, Map<Optional<A>, Binding<A>> index) throws IOException {
        if (index.containsKey(ANY)) {
            return index.get(ANY).execute(response, converters);
        }
        Function<Optional, String> toName = a -> a.map(Object::toString).orElse("any");
        List attributes = index.keySet().stream().map(toName).collect(Collectors.toList());
        String message = String.format("Unable to dispatch %s onto %s", attribute.map(Object::toString).orElse("none"), attributes);
        throw new UnsupportedResponseException(message, response);
    }
}

