/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import com.google.common.reflect.TypeToken;
import java.util.Optional;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.Captured;

public final class Retriever {
    private final Captured captured;

    public Retriever(Captured captured) {
        this.captured = captured;
    }

    public <T> Optional<T> retrieve(Class<T> type) {
        return this.retrieve(TypeToken.of(type));
    }

    public <T> Optional<T> retrieve(TypeToken<?> type) {
        return Optional.ofNullable(this.captured.getValue()).filter(v -> this.hasRetrieved(type)).map(v -> {
            Object t = v;
            return t;
        });
    }

    public Optional<ClientHttpResponse> retrieveResponse() {
        return this.retrieve(ClientHttpResponse.class);
    }

    public boolean hasRetrieved(Class<?> type) {
        return this.hasRetrieved(TypeToken.of(type));
    }

    public boolean hasRetrieved(TypeToken<?> type) {
        return this.captured.isAssignableTo(type);
    }
}

