/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.zalando.riptide.Binding;
import org.zalando.riptide.Captured;
import org.zalando.riptide.Retriever;
import org.zalando.riptide.Router;
import org.zalando.riptide.Selector;
import org.zalando.riptide.UnsupportedResponseException;

public final class Dispatcher {
    private final RestTemplate template;
    private final ClientHttpResponse response;
    private final Router router = new Router();

    Dispatcher(RestTemplate template, ClientHttpResponse response) {
        this.template = template;
        this.response = response;
    }

    @SafeVarargs
    public final <A> Retriever dispatch(Selector<A> selector, Binding<A> ... bindings) throws UnsupportedResponseException {
        List converters = this.template.getMessageConverters();
        Captured value = this.route(selector, converters, bindings);
        return new Retriever(value);
    }

    private <A> Captured route(Selector<A> selector, List<HttpMessageConverter<?>> converters, Binding<A>[] bindings) {
        try {
            return this.router.route(this.response, converters, selector, Arrays.asList(bindings));
        }
        catch (IOException e) {
            throw new RestClientException(null, (Throwable)e);
        }
    }
}

