/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.Binding;
import org.zalando.riptide.Captured;
import org.zalando.riptide.Capturer;
import org.zalando.riptide.Router;
import org.zalando.riptide.Selector;
import org.zalando.riptide.ThrowingConsumer;
import org.zalando.riptide.ThrowingFunction;
import org.zalando.riptide.UnsupportedResponseException;

public final class UntypedCondition<A> {
    private final Router router = new Router();
    private final Optional<A> attribute;

    public UntypedCondition(Optional<A> attribute) {
        this.attribute = attribute;
    }

    public Binding<A> call(ThrowingConsumer<ClientHttpResponse, IOException> consumer) {
        return Binding.create(this.attribute, (response, converters) -> {
            consumer.accept(response);
            return Captured.wrapNothing();
        });
    }

    public Capturer<A> map(ThrowingFunction<ClientHttpResponse, ?, IOException> function) {
        return () -> Binding.create(this.attribute, (response, converters) -> Captured.wrap(function.apply(response)));
    }

    public <T> Capturer<A> map(ThrowingFunction<ClientHttpResponse, ?, IOException> function, Class<T> mappedType) {
        return this.map(function, TypeToken.of(mappedType));
    }

    public <T> Capturer<A> map(ThrowingFunction<ClientHttpResponse, ?, IOException> function, TypeToken<T> mappedType) {
        return () -> Binding.create(this.attribute, (response, converters) -> Captured.wrap(function.apply(response), mappedType));
    }

    public Binding<A> capture() {
        return Binding.create(this.attribute, (response, converters) -> Captured.wrap((Object)response, ClientHttpResponse.class));
    }

    @SafeVarargs
    public final <B> Binding<A> dispatch(Selector<B> selector, Binding<B> ... bindings) throws UnsupportedResponseException {
        return Binding.create(this.attribute, (response, converters) -> this.router.route(response, converters, selector, Arrays.asList(bindings)));
    }
}

