/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import com.google.common.reflect.TypeToken;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.zalando.riptide.RawCapture;
import org.zalando.riptide.TypedCapture;

@Immutable
interface Capture<T> {
    public Optional<T> getValue();

    public boolean isAssignableTo(TypeToken<?> var1);

    public static <T> Capture<T> captured(@Nullable T value, Class<T> type) {
        return Capture.captured(value, TypeToken.of(type));
    }

    public static <T> Capture<T> captured(@Nullable T value, TypeToken<T> type) {
        return new TypedCapture<T>(Optional.ofNullable(value), type);
    }

    public static <T> Capture<T> wrapNothing() {
        return Capture.captured(null);
    }

    public static <T> Capture<T> captured(@Nullable T value) {
        return new RawCapture<T>(Optional.ofNullable(value));
    }
}

