/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.Binding;
import org.zalando.riptide.Selector;

final class ContentTypeSelector
implements Selector<MediaType> {
    private static final Comparator<Binding<MediaType>> BY_SPECIFICITY = Comparator.comparing(b -> (MediaType)b.getAttribute().get(), MediaType.SPECIFICITY_COMPARATOR);

    ContentTypeSelector() {
    }

    @Override
    public Optional<MediaType> attributeOf(ClientHttpResponse response) {
        return Optional.ofNullable(response.getHeaders().getContentType());
    }

    @Override
    public Optional<Binding<MediaType>> select(Optional<MediaType> attribute, Map<Optional<MediaType>, Binding<MediaType>> bindings) {
        return this.exactMatch(attribute, bindings).map(Optional::of).orElseGet(this.bestMatch(attribute, bindings));
    }

    private Optional<Binding<MediaType>> exactMatch(Optional<MediaType> attribute, Map<Optional<MediaType>, Binding<MediaType>> bindings) {
        return Selector.super.select(attribute, bindings);
    }

    private Supplier<Optional<Binding<MediaType>>> bestMatch(Optional<MediaType> attribute, Map<Optional<MediaType>, Binding<MediaType>> bindings) {
        return () -> attribute.flatMap(a -> bindings.values().stream().filter(b -> b.getAttribute().isPresent()).sorted(BY_SPECIFICITY).filter(b -> ((MediaType)b.getAttribute().get()).includes(a)).findFirst());
    }
}

