/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import java.util.Arrays;
import java.util.List;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RestTemplate;
import org.zalando.riptide.Binding;
import org.zalando.riptide.Capture;
import org.zalando.riptide.Retriever;
import org.zalando.riptide.Router;
import org.zalando.riptide.Selector;

public final class Dispatcher {
    private final RestTemplate template;
    private final ClientHttpResponse response;
    private final Router router = new Router();

    Dispatcher(RestTemplate template, ClientHttpResponse response) {
        this.template = template;
        this.response = response;
    }

    @SafeVarargs
    public final <A> Retriever dispatch(Selector<A> selector, Binding<A> ... bindings) {
        List converters = this.template.getMessageConverters();
        Capture value = this.router.route(this.response, converters, selector, Arrays.asList(bindings));
        return new Retriever(value);
    }
}

