/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Optional;
import org.zalando.riptide.Capture;

public final class Retriever {
    private final Capture<?> capture;

    public Retriever(Capture<?> capture) {
        this.capture = capture;
    }

    public <T> Optional<T> retrieve(Class<T> type) {
        return this.retrieve(TypeToken.of(type));
    }

    public <T> Optional<T> retrieve(TypeToken<T> type) {
        if (this.capture.isAssignableTo(type)) {
            return this.capture.getValue().map(this::cast);
        }
        return Optional.empty();
    }

    private <T> T cast(Object value) {
        return (T)value;
    }

    public boolean hasRetrieved(Class<?> type) {
        return this.hasRetrieved(TypeToken.of(type));
    }

    public boolean hasRetrieved(TypeToken<?> type) {
        return this.capture.isAssignableTo(type);
    }

    public static <T> TypeToken<List<T>> listOf(Class<T> entityType) {
        return Retriever.listOf(TypeToken.of(entityType));
    }

    public static <T> TypeToken<List<T>> listOf(TypeToken<T> entityType) {
        TypeToken listType = new TypeToken<List<T>>(){};
        TypeParameter elementType = new TypeParameter<T>(){};
        return listType.where(elementType, entityType);
    }
}

