/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.zalando.riptide.RawCapture;
import org.zalando.riptide.TypedCapture;

@Immutable
public interface Capture {
    default public boolean has(Class<?> type) {
        return this.has(TypeToken.of(type));
    }

    public boolean has(TypeToken<?> var1);

    default public <T> Optional<T> as(Class<T> type) {
        return this.as(TypeToken.of(type));
    }

    public <T> Optional<T> as(TypeToken<T> var1);

    default public <T> T to(Class<T> type) {
        return this.to(TypeToken.of(type));
    }

    default public <T> T to(TypeToken<T> type) {
        return this.as(type).orElseThrow(AssertionError::new);
    }

    public static Capture none() {
        return Capture.valueOf(null);
    }

    public static <T> Capture valueOf(@Nullable T value) {
        return new RawCapture(Optional.ofNullable(value));
    }

    public static <T> Capture valueOf(@Nullable T value, Class<T> type) {
        return Capture.valueOf(value, TypeToken.of(type));
    }

    public static <T> Capture valueOf(@Nullable T value, TypeToken<T> type) {
        return new TypedCapture<T>(Optional.ofNullable(value), type);
    }

    public static <T> TypeToken<List<T>> listOf(Class<T> entityType) {
        return Capture.listOf(TypeToken.of(entityType));
    }

    public static <T> TypeToken<List<T>> listOf(TypeToken<T> entityType) {
        TypeToken listType = new TypeToken<List<T>>(){};
        TypeParameter elementType = new TypeParameter<T>(){};
        return listType.where(elementType, entityType);
    }
}

