/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.client.RestClientException;
import org.zalando.riptide.Binding;
import org.zalando.riptide.Capture;
import org.zalando.riptide.NoRouteException;
import org.zalando.riptide.Selector;

final class Router {
    private static final Optional WILDCARD = Optional.empty();

    Router() {
    }

    final <A> Capture route(ClientHttpResponse response, List<HttpMessageConverter<?>> converters, Selector<A> selector, Collection<Binding<A>> bindings) {
        Optional<A> attribute;
        try {
            attribute = selector.attributeOf(response);
        }
        catch (IOException e) {
            throw new RestClientException("Unable to retrieve attribute of response", (Throwable)e);
        }
        Map index = bindings.stream().collect(Collectors.toMap(Binding::getAttribute, Function.identity(), this::denyDuplicates, LinkedHashMap::new));
        Optional<Binding<A>> match = selector.select(attribute, index);
        try {
            if (match.isPresent()) {
                Binding<A> binding = match.get();
                try {
                    return binding.execute(response, converters);
                }
                catch (NoRouteException e) {
                    return this.propagateNoMatch(response, converters, index, e);
                }
            }
            return this.routeNone(response, converters, index);
        }
        catch (IOException e) {
            throw new RestClientException("Unable to execute binding", (Throwable)e);
        }
    }

    private <A> Binding<A> denyDuplicates(Binding<A> left, Binding<A> right) {
        left.getAttribute().ifPresent(a -> {
            throw new IllegalStateException("Duplicate condition attribute: " + a);
        });
        throw new IllegalStateException("Duplicate any conditions");
    }

    private <A> Capture propagateNoMatch(ClientHttpResponse response, List<HttpMessageConverter<?>> converters, Map<Optional<A>, Binding<A>> bindings, NoRouteException e) throws IOException {
        try {
            return this.routeNone(response, converters, bindings);
        }
        catch (NoRouteException ignored) {
            throw e;
        }
    }

    private <A> Capture routeNone(ClientHttpResponse response, List<HttpMessageConverter<?>> converters, Map<Optional<A>, Binding<A>> bindings) throws IOException {
        if (this.containsWildcard(bindings)) {
            Binding<A> binding = this.getWildcard(bindings);
            return binding.execute(response, converters);
        }
        throw new NoRouteException(response);
    }

    private <A> boolean containsWildcard(Map<Optional<A>, Binding<A>> bindings) {
        return bindings.containsKey(WILDCARD);
    }

    private <A> Binding<A> getWildcard(Map<Optional<A>, Binding<A>> bindings) {
        return bindings.get(WILDCARD);
    }
}

