/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;

final class BufferingClientHttpResponse
implements ClientHttpResponse {
    private final ClientHttpResponse response;
    private final Optional<byte[]> body;

    private BufferingClientHttpResponse(ClientHttpResponse response, Optional<byte[]> body) {
        this.response = response;
        this.body = body;
    }

    public HttpStatus getStatusCode() throws IOException {
        return this.response.getStatusCode();
    }

    public int getRawStatusCode() throws IOException {
        return this.response.getRawStatusCode();
    }

    public String getStatusText() throws IOException {
        return this.response.getStatusText();
    }

    public HttpHeaders getHeaders() {
        return this.response.getHeaders();
    }

    public InputStream getBody() {
        return this.body.map(ByteArrayInputStream::new).orElse(null);
    }

    public void close() {
        this.response.close();
    }

    public static BufferingClientHttpResponse buffer(ClientHttpResponse response) throws IOException {
        if (response.getBody() == null) {
            return new BufferingClientHttpResponse(response, Optional.empty());
        }
        byte[] bytes = ByteStreams.toByteArray((InputStream)response.getBody());
        return new BufferingClientHttpResponse(response, Optional.of(bytes));
    }
}

