/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.RestClientException;

final class Callback<T>
implements RequestCallback {
    private final List<HttpMessageConverter<?>> converters;
    private final HttpEntity<T> entity;

    Callback(List<HttpMessageConverter<?>> converters, HttpEntity<T> entity) {
        this.converters = converters;
        this.entity = entity;
    }

    public void doWithRequest(ClientHttpRequest request) throws IOException {
        HttpHeaders headers = this.entity.getHeaders();
        request.getHeaders().putAll((Map)headers);
        Object body = this.entity.getBody();
        if (body == null) {
            return;
        }
        Class<?> type = body.getClass();
        MediaType contentType = headers.getContentType();
        Optional<HttpMessageConverter> match = this.converters.stream().filter(c -> c.canWrite(type, contentType)).map(this::cast).findFirst();
        if (!match.isPresent()) {
            String message = String.format("Could not write request: no suitable HttpMessageConverter found for request type [%s]", type.getName());
            if (contentType == null) {
                throw new RestClientException(message);
            }
            throw new RestClientException(String.format("%s and content type [%s]", message, contentType));
        }
        HttpMessageConverter converter = match.get();
        converter.write(body, contentType, (HttpOutputMessage)request);
    }

    private HttpMessageConverter<T> cast(HttpMessageConverter<?> converter) {
        return converter;
    }
}

