/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import com.google.common.reflect.TypeToken;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.zalando.riptide.Capture;

@Immutable
final class TypedCapture<T>
implements Capture {
    private final Optional<T> value;
    private final TypeToken<T> type;

    TypedCapture(Optional<T> value, TypeToken<T> type) {
        this.value = value;
        this.type = type;
    }

    @Override
    public boolean has(TypeToken<?> other) {
        return other.isAssignableFrom(this.type);
    }

    public <O> Optional<O> as(TypeToken<O> type) {
        return this.has(type) ? this.value.map(v -> v) : Optional.empty();
    }
}

