/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.Optional;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.riptide.Binding;
import org.zalando.riptide.Capture;
import org.zalando.riptide.Capturer;
import org.zalando.riptide.Router;
import org.zalando.riptide.Selector;
import org.zalando.riptide.ThrowingConsumer;
import org.zalando.riptide.ThrowingFunction;

public final class UntypedCondition<A> {
    private final Router router = new Router();
    private final Optional<A> attribute;

    UntypedCondition(Optional<A> attribute) {
        this.attribute = attribute;
    }

    public Binding<A> call(ThrowingConsumer<ClientHttpResponse, ?> consumer) {
        return Binding.create(this.attribute, (response, converters) -> {
            consumer.accept(response);
            return Capture.none();
        });
    }

    public Capturer<A> map(ThrowingFunction<ClientHttpResponse, ?, ?> function) {
        return () -> Binding.create(this.attribute, (response, converters) -> Capture.valueOf(function.apply(response)));
    }

    public <T> Capturer<A> map(ThrowingFunction<ClientHttpResponse, T, ?> function, Class<T> mappedType) {
        return this.map(function, TypeToken.of(mappedType));
    }

    public <T> Capturer<A> map(ThrowingFunction<ClientHttpResponse, T, ?> function, TypeToken<T> mappedType) {
        return () -> Binding.create(this.attribute, (response, converters) -> Capture.valueOf(function.apply(response), mappedType));
    }

    public Binding<A> capture() {
        return Binding.create(this.attribute, (response, converters) -> Capture.valueOf(response, ClientHttpResponse.class));
    }

    public Binding<A> capture(ThrowingFunction<ClientHttpResponse, ?, ?> function) {
        return this.map(function).capture();
    }

    public <T> Binding<A> capture(ThrowingFunction<ClientHttpResponse, T, ?> function, Class<T> mappedType) {
        return this.capture(function, TypeToken.of(mappedType));
    }

    public <T> Binding<A> capture(ThrowingFunction<ClientHttpResponse, T, ?> function, TypeToken<T> mappedType) {
        return this.map(function, mappedType).capture();
    }

    @SafeVarargs
    public final <B> Binding<A> dispatch(Selector<B> selector, Binding<B> ... bindings) {
        return Binding.create(this.attribute, (response, converters) -> this.router.route(response, converters, selector, Arrays.asList(bindings)));
    }
}

