/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.SuccessCallback;
import org.zalando.riptide.AlreadyConsumedResponseException;
import org.zalando.riptide.AsyncRest;
import org.zalando.riptide.Binding;
import org.zalando.riptide.Router;
import org.zalando.riptide.Selector;

public final class AsyncDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncRest.class);
    private final List<HttpMessageConverter<?>> converters;
    private final ListenableFuture<ClientHttpResponse> future;
    private final Router router;

    AsyncDispatcher(List<HttpMessageConverter<?>> converters, ListenableFuture<ClientHttpResponse> future, Router router) {
        this.converters = converters;
        this.future = future;
        this.router = router;
    }

    @SafeVarargs
    public final <A> void dispatch(Selector<A> selector, Binding<A> ... bindings) {
        this.dispatch(selector, Binding.route(bindings), AsyncRest.handle(throwable -> LOG.error("Failed to dispatch asynchronously", throwable)));
    }

    public final <A> void dispatch(Selector<A> selector, List<Binding<A>> bindings, FailureCallback callback) {
        SuccessCallback success = response -> this.router.route((ClientHttpResponse)response, this.converters, selector, bindings);
        FailureCallback failure = exception -> {
            try {
                throw exception;
            }
            catch (AlreadyConsumedResponseException e) {
                success.onSuccess((Object)e.getResponse());
            }
            catch (Throwable throwable) {
                callback.onFailure(throwable);
            }
        };
        this.future.addCallback(success, failure);
    }
}

