/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import com.google.gag.annotation.remark.OhNoYouDidnt;
import java.net.URI;
import java.util.List;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.client.AsyncRestTemplate;
import org.zalando.riptide.AsyncDispatcher;
import org.zalando.riptide.AsyncRequestCallbackAdapter;
import org.zalando.riptide.BufferingClientHttpResponse;
import org.zalando.riptide.Callback;
import org.zalando.riptide.Router;

public final class AsyncRest {
    private final AsyncRestTemplate template;
    private final Router router = new Router();

    private AsyncRest(AsyncRestTemplate template) {
        this.template = template;
    }

    public AsyncDispatcher execute(HttpMethod method, URI url) {
        return this.execute(method, url, HttpEntity.EMPTY);
    }

    public AsyncDispatcher execute(HttpMethod method, URI url, HttpHeaders headers) {
        return this.execute(method, url, new HttpEntity((MultiValueMap)headers));
    }

    public AsyncDispatcher execute(HttpMethod method, URI url, Object body) {
        return this.execute(method, url, new HttpEntity(body));
    }

    public AsyncDispatcher execute(HttpMethod method, URI url, HttpHeaders headers, Object body) {
        return this.execute(method, url, new HttpEntity(body, (MultiValueMap)headers));
    }

    private <T> AsyncDispatcher execute(HttpMethod method, URI url, HttpEntity<T> entity) {
        List converters = this.template.getMessageConverters();
        Callback<T> callback = new Callback<T>(converters, entity);
        ListenableFuture future = this.template.execute(url, method, new AsyncRequestCallbackAdapter<T>(callback), BufferingClientHttpResponse::buffer);
        return new AsyncDispatcher(converters, (ListenableFuture<ClientHttpResponse>)future, this.router);
    }

    public static AsyncRest create(AsyncRestTemplate template) {
        return new AsyncRest(template);
    }

    @OhNoYouDidnt
    public static FailureCallback handle(FailureCallback callback) {
        return callback;
    }
}

