/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import java.util.Arrays;
import java.util.List;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConverter;
import org.zalando.riptide.Binding;
import org.zalando.riptide.Capture;
import org.zalando.riptide.Router;
import org.zalando.riptide.Selector;

public final class Dispatcher {
    private final List<HttpMessageConverter<?>> converters;
    private final ClientHttpResponse response;
    private final Router router;

    Dispatcher(List<HttpMessageConverter<?>> converters, ClientHttpResponse response, Router router) {
        this.converters = converters;
        this.response = response;
        this.router = router;
    }

    @SafeVarargs
    public final <A> Capture dispatch(Selector<A> selector, Binding<A> ... bindings) {
        return this.dispatch(selector, Arrays.asList(bindings));
    }

    public final <A> Capture dispatch(Selector<A> selector, List<Binding<A>> bindings) {
        return this.router.route(this.response, this.converters, selector, bindings);
    }
}

