/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import java.net.URI;
import java.util.List;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.zalando.riptide.AlreadyConsumedResponseException;
import org.zalando.riptide.BufferingClientHttpResponse;
import org.zalando.riptide.Callback;
import org.zalando.riptide.Dispatcher;
import org.zalando.riptide.Router;

public final class Rest {
    private final RestTemplate template;
    private final Router router = new Router();

    private Rest(RestTemplate template) {
        this.template = template;
    }

    public Dispatcher execute(HttpMethod method, URI url) {
        return this.execute(method, url, HttpEntity.EMPTY);
    }

    public Dispatcher execute(HttpMethod method, URI url, HttpHeaders headers) {
        return this.execute(method, url, new HttpEntity((MultiValueMap)headers));
    }

    public Dispatcher execute(HttpMethod method, URI url, Object body) {
        return this.execute(method, url, new HttpEntity(body));
    }

    public Dispatcher execute(HttpMethod method, URI url, HttpHeaders headers, Object body) {
        return this.execute(method, url, new HttpEntity(body, (MultiValueMap)headers));
    }

    private <T> Dispatcher execute(HttpMethod method, URI url, HttpEntity<T> entity) {
        List converters = this.template.getMessageConverters();
        Callback<T> callback = new Callback<T>(converters, entity);
        ClientHttpResponse response = this.execute(method, url, callback);
        return new Dispatcher(converters, response, this.router);
    }

    private <T> ClientHttpResponse execute(HttpMethod method, URI url, Callback<T> callback) {
        try {
            return (ClientHttpResponse)this.template.execute(url, method, callback, BufferingClientHttpResponse::buffer);
        }
        catch (AlreadyConsumedResponseException e) {
            return e.getResponse();
        }
    }

    public static Rest create(RestTemplate template) {
        return new Rest(template);
    }
}

