/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide;

import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpMessageConverterExtractor;
import org.zalando.riptide.Binding;
import org.zalando.riptide.Capture;
import org.zalando.riptide.Capturer;
import org.zalando.riptide.EntityConsumer;
import org.zalando.riptide.EntityFunction;
import org.zalando.riptide.ResponseEntityConsumer;
import org.zalando.riptide.ResponseEntityFunction;

public final class TypedCondition<A, I>
implements Capturer<A> {
    private final A attribute;
    private final TypeToken<I> type;

    public TypedCondition(A attribute, TypeToken<I> type) {
        this.attribute = attribute;
        this.type = type;
    }

    private ResponseEntity<I> toResponseEntity(I entity, ClientHttpResponse response) throws IOException {
        return new ResponseEntity(entity, (MultiValueMap)response.getHeaders(), response.getStatusCode());
    }

    public Binding<A> call(EntityConsumer<I, ?> consumer) {
        return Binding.create(this.attribute, (response, converters) -> {
            I entity = this.convert(response, converters);
            consumer.accept(entity);
            return Capture.none();
        });
    }

    private I convert(ClientHttpResponse response, List<HttpMessageConverter<?>> converters) throws IOException {
        return (I)new HttpMessageConverterExtractor(this.type.getType(), converters).extractData(response);
    }

    public Binding<A> call(ResponseEntityConsumer<I, ?> consumer) {
        return Binding.create(this.attribute, (response, converters) -> {
            I entity = this.convert(response, converters);
            consumer.accept(this.toResponseEntity(entity, response));
            return Capture.none();
        });
    }

    public Capturer<A> map(EntityFunction<I, ?, ?> function) {
        return () -> Binding.create(this.attribute, (response, converters) -> {
            I entity = this.convert(response, converters);
            return Capture.valueOf(function.apply(entity));
        });
    }

    public <T> Capturer<A> map(EntityFunction<I, T, ?> function, Class<T> mappedType) {
        return this.map(function, TypeToken.of(mappedType));
    }

    public <T> Capturer<A> map(EntityFunction<I, T, ?> function, TypeToken<T> mappedType) {
        return () -> Binding.create(this.attribute, (response, converters) -> {
            I entity = this.convert(response, converters);
            return Capture.valueOf(function.apply(entity), mappedType);
        });
    }

    public Capturer<A> map(ResponseEntityFunction<I, ?, ?> function) {
        return () -> Binding.create(this.attribute, (response, converters) -> {
            I entity = this.convert(response, converters);
            return Capture.valueOf(function.apply(this.toResponseEntity(entity, response)));
        });
    }

    public <T> Capturer<A> map(ResponseEntityFunction<I, T, ?> function, Class<T> mappedType) {
        return this.map(function, TypeToken.of(mappedType));
    }

    public <T> Capturer<A> map(ResponseEntityFunction<I, T, ?> function, TypeToken<T> mappedType) {
        return () -> Binding.create(this.attribute, (response, converters) -> {
            I entity = this.convert(response, converters);
            return Capture.valueOf(function.apply(this.toResponseEntity(entity, response)), mappedType);
        });
    }

    @Override
    public Binding<A> capture() {
        return Binding.create(this.attribute, (response, converters) -> Capture.valueOf(this.convert(response, converters), this.type));
    }

    public Binding<A> capture(EntityFunction<I, ?, ?> function) {
        return this.map(function).capture();
    }

    public <T> Binding<A> capture(EntityFunction<I, T, ?> function, Class<T> mappedType) {
        return this.capture(function, TypeToken.of(mappedType));
    }

    public <T> Binding<A> capture(EntityFunction<I, T, ?> function, TypeToken<T> mappedType) {
        return this.map(function, mappedType).capture();
    }

    public Binding<A> capture(ResponseEntityFunction<I, ?, ?> function) {
        return this.map(function).capture();
    }

    public <T> Binding<A> capture(ResponseEntityFunction<I, T, ?> function, Class<T> mappedType) {
        return this.capture(function, TypeToken.of(mappedType));
    }

    public <T> Binding<A> capture(ResponseEntityFunction<I, T, ?> function, TypeToken<T> mappedType) {
        return this.map(function, mappedType).capture();
    }
}

