/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spring.boot.nakadi.config;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.zalando.fahrschein.AccessTokenProvider;
import org.zalando.fahrschein.NakadiClient;
import org.zalando.spring.boot.config.Registry;
import org.zalando.spring.boot.nakadi.NakadiConsumer;
import org.zalando.spring.boot.nakadi.NakadiPublisher;
import org.zalando.spring.boot.nakadi.config.NakadiClientFactory;
import org.zalando.spring.boot.nakadi.config.NakadiClientsProperties;
import org.zalando.spring.boot.nakadi.config.NakadiClientsRegistrar;
import org.zalando.spring.boot.nakadi.config.NakadiConsumerFactory;
import org.zalando.spring.boot.nakadi.config.NakadiPublisherFactory;
import org.zalando.stups.tokens.AccessTokens;

public class DefaultNakadiClientsRegistrar
implements NakadiClientsRegistrar {
    private static final Logger log = LoggerFactory.getLogger(DefaultNakadiClientsRegistrar.class);
    private final Registry registry;
    private final NakadiClientsProperties properties;
    private final AccessTokens accessTokens;
    private AccessTokenProvider noopAccessTokenProvider = new AccessTokenProvider(){

        public String getAccessToken() throws IOException {
            return "NOOP_ACCESS_TOKEN";
        }
    };

    @Override
    public void register() {
        this.properties.getClients().forEach((clientId, client) -> {
            String registeredClientId = this.registerNakadiClient((String)clientId, (NakadiClientsProperties.Client)client);
            client.getConsumers().forEach((consumerId, listener) -> this.registerConsumer(registeredClientId, (String)consumerId, (NakadiClientsProperties.Client.NakadiConsumerConfig)listener));
            client.getPublishers().stream().forEach(publisherId -> this.registerPublisher(registeredClientId, (String)publisherId));
        });
    }

    private String registerNakadiClient(String id, NakadiClientsProperties.Client client) {
        return this.registry.registerIfAbsent(id, NakadiClient.class, () -> {
            log.info("NakadiClient: [{}] registered", (Object)id);
            return BeanDefinitionBuilder.genericBeanDefinition(NakadiClientFactory.class).addConstructorArgValue((Object)this.buildAccessTokenProvider(client.getAccessTokenId())).addConstructorArgValue((Object)client).setFactoryMethod("create");
        });
    }

    private String registerConsumer(String nakadiClientId, String listenerId, NakadiClientsProperties.Client.NakadiConsumerConfig sub) {
        return this.registry.registerIfAbsent(listenerId, NakadiConsumer.class, () -> {
            log.info("NakadiConsumer: [{}] registered with NakadiClient: [{}]", (Object)listenerId, (Object)nakadiClientId);
            return BeanDefinitionBuilder.genericBeanDefinition(NakadiConsumerFactory.class).addConstructorArgReference(nakadiClientId).addConstructorArgValue((Object)sub).setFactoryMethod("create");
        });
    }

    private String registerPublisher(String nakadiClientId, String publisherId) {
        return this.registry.registerIfAbsent(publisherId, NakadiPublisher.class, () -> {
            log.info("NakadiPublisher: [{}] registered with NakadiClient: [{}]", (Object)publisherId, (Object)nakadiClientId);
            return BeanDefinitionBuilder.genericBeanDefinition(NakadiPublisherFactory.class).addConstructorArgReference(nakadiClientId).setFactoryMethod("create");
        });
    }

    protected AccessTokenProvider buildAccessTokenProvider(final String accessTokenId) {
        return accessTokenId == null ? this.noopAccessTokenProvider : new AccessTokenProvider(){

            public String getAccessToken() throws IOException {
                return DefaultNakadiClientsRegistrar.this.accessTokens.get((Object)accessTokenId);
            }
        };
    }

    public DefaultNakadiClientsRegistrar(Registry registry, NakadiClientsProperties properties, AccessTokens accessTokens) {
        this.registry = registry;
        this.properties = properties;
        this.accessTokens = accessTokens;
    }
}

