/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spring.boot.nakadi.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.fahrschein.AccessTokenProvider;
import org.zalando.fahrschein.NakadiClient;
import org.zalando.fahrschein.NakadiClientBuilder;
import org.zalando.fahrschein.http.apache.HttpComponentsRequestFactory;
import org.zalando.fahrschein.http.api.RequestFactory;
import org.zalando.spring.boot.nakadi.config.AbstractConfig;
import org.zalando.spring.boot.nakadi.config.HttpConfig;

public class FahrscheinNakadiClientFactory {
    private static final Logger log = LoggerFactory.getLogger(FahrscheinNakadiClientFactory.class);

    public static NakadiClient create(AccessTokenProvider accessTokenProvider, AbstractConfig config) {
        ObjectMapper objectMapper = FahrscheinNakadiClientFactory.buildObjectMapper();
        CloseableHttpClient closeableHttpClient = FahrscheinNakadiClientFactory.buildCloseableHttpClient(config.getHttp());
        NakadiClientBuilder ncb = NakadiClient.builder((URI)URI.create(config.getNakadiUrl())).withRequestFactory((RequestFactory)new HttpComponentsRequestFactory((HttpClient)closeableHttpClient)).withObjectMapper(objectMapper);
        if (config.getOauth().getEnabled().booleanValue()) {
            ncb = ncb.withAccessTokenProvider(accessTokenProvider);
        } else {
            log.info("NakadiClient: [{}] - No AccessTokenProvider configured. No 'accessTokenId' was set.", (Object)config.getId());
        }
        return ncb.build();
    }

    protected static CloseableHttpClient buildCloseableHttpClient(HttpConfig httpConfig) {
        RequestConfig config = RequestConfig.custom().setSocketTimeout((int)TimeUnit.MILLISECONDS.convert(httpConfig.getSocketTimeout().getAmount(), httpConfig.getSocketTimeout().getUnit())).setConnectTimeout((int)TimeUnit.MILLISECONDS.convert(httpConfig.getConnectTimeout().getAmount(), httpConfig.getConnectTimeout().getUnit())).setConnectionRequestTimeout((int)TimeUnit.MILLISECONDS.convert(httpConfig.getConnectionRequestTimeout().getAmount(), httpConfig.getConnectionRequestTimeout().getUnit())).build();
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setBufferSize(httpConfig.getBufferSize().intValue()).build();
        HttpClientBuilder builder = HttpClients.custom().setDefaultRequestConfig(config).setDefaultConnectionConfig(connectionConfig).setConnectionTimeToLive(httpConfig.getConnectionTimeToLive().getAmount(), httpConfig.getConnectionTimeToLive().getUnit()).disableAutomaticRetries().disableRedirectHandling().setMaxConnTotal(httpConfig.getMaxConnectionsTotal().intValue()).setMaxConnPerRoute(httpConfig.getMaxConnectionsPerRoute().intValue());
        if (httpConfig.getEvictExpiredConnections().booleanValue()) {
            builder = builder.evictExpiredConnections();
        }
        if (httpConfig.getEvictIdleConnections().booleanValue()) {
            builder = builder.evictIdleConnections(httpConfig.getMaxIdleTime().longValue(), TimeUnit.MILLISECONDS);
        }
        return builder.build();
    }

    private static ObjectMapper buildObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.registerModules(new Module[]{new Jdk8Module(), new ParameterNamesModule(), new JavaTimeModule()});
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return objectMapper;
    }
}

