/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spring.boot.nakadi.config;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.zalando.fahrschein.EventAlreadyProcessedException;
import org.zalando.spring.boot.nakadi.NakadiListener;

public class MeterNakadiListener<T>
implements NakadiListener<T> {
    private final NakadiListener<T> delegate;
    private final MeterRegistry meterRegistry;
    private Timer successTimer;
    private Timer failureTimer;
    private Counter inputCounter;

    public void init() {
        this.successTimer = this.meterRegistry.timer("success", (Iterable)Tags.empty());
        this.failureTimer = this.meterRegistry.timer("failure", (Iterable)Tags.empty());
        this.inputCounter = this.meterRegistry.counter("input", (Iterable)Tags.empty());
    }

    public void accept(List<T> events) throws IOException, EventAlreadyProcessedException {
        this.inputCounter.increment(events != null ? (double)events.size() : 0.0);
        long start = System.currentTimeMillis();
        boolean failure = false;
        try {
            this.delegate.accept(events);
        }
        catch (IOException e) {
            failure = true;
            throw e;
        }
        catch (EventAlreadyProcessedException e) {
            failure = true;
            throw e;
        }
        finally {
            if (failure) {
                this.failureTimer.record(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS);
            } else {
                this.successTimer.record(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public Class<T> getEventType() {
        return this.delegate.getEventType();
    }

    public MeterNakadiListener(NakadiListener<T> delegate, MeterRegistry meterRegistry) {
        this.delegate = delegate;
        this.meterRegistry = meterRegistry;
    }
}

