/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spring.boot.nakadi.config;

import io.micrometer.core.instrument.MeterRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.zalando.spring.boot.nakadi.MeterRegistryAware;

public class MeterRegistryAwareBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(MeterRegistryAwareBeanPostProcessor.class);
    private BeanFactory beanFactory;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof MeterRegistryAware) {
            MeterRegistry reg = (MeterRegistry)this.beanFactory.getBean(MeterRegistry.class);
            ((MeterRegistryAware)bean).setMeterRegistry(reg);
            log.debug("MeterRegistry injected into bean : {}", (Object)beanName);
        }
        return bean;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

