/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spring.boot.nakadi.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.env.Environment;
import org.zalando.fahrschein.NakadiClient;
import org.zalando.spring.boot.config.Registry;
import org.zalando.spring.boot.nakadi.NakadiPublisher;
import org.zalando.spring.boot.nakadi.config.AbstractConfig;
import org.zalando.spring.boot.nakadi.config.ConsumerConfig;
import org.zalando.spring.boot.nakadi.config.DefaultNakadiPublisher;
import org.zalando.spring.boot.nakadi.config.FahrscheinConfigProperties;
import org.zalando.spring.boot.nakadi.config.FahrscheinNakadiClientFactory;
import org.zalando.spring.boot.nakadi.config.FahrscheinNakadiConsumer;
import org.zalando.spring.boot.nakadi.config.NakadiClientsRegistrar;
import org.zalando.spring.boot.nakadi.config.NakadiConsumer;
import org.zalando.spring.boot.nakadi.config.NakadiListenerContainer;
import org.zalando.spring.boot.nakadi.config.PublisherConfig;

public class FahrscheinRegistrar
implements NakadiClientsRegistrar {
    private static final Logger log = LoggerFactory.getLogger(FahrscheinRegistrar.class);
    private static final String LOG_PREFIX = "[{}] - register ";
    private final Registry registry;
    private final FahrscheinConfigProperties fahrscheinConfigProperties;
    private final Environment environment;

    @Override
    public void register() {
        this.fahrscheinConfigProperties.getConsumers().forEach((consumerId, consumerConfig) -> {
            this.registerNakadiListenerContainer((ConsumerConfig)consumerConfig);
            log.info("[{}] - Consumer registered", (Object)consumerConfig.getId());
        });
        this.registerPublisher(this.fahrscheinConfigProperties.getPublisher());
    }

    private String registerNakadiListenerContainer(ConsumerConfig consumerConfig) {
        return this.registry.registerIfAbsent(consumerConfig.getId(), NakadiListenerContainer.class, () -> {
            log.info("[{}] - register NakadiListenerContainer ...", (Object)consumerConfig.getId());
            return BeanDefinitionBuilder.genericBeanDefinition(NakadiListenerContainer.class).addConstructorArgReference(this.registerNakadiConsumer(consumerConfig)).addConstructorArgReference(consumerConfig.getId() + "NakadiListener").addPropertyValue("autoStartup", (Object)consumerConfig.getAutostartEnabled());
        });
    }

    private String registerNakadiConsumer(ConsumerConfig consumerConfig) {
        return this.registry.registerIfAbsent(consumerConfig.getId(), NakadiConsumer.class, () -> {
            log.info("[{}] - register NakadiConsumer ...", (Object)consumerConfig.getId());
            return BeanDefinitionBuilder.genericBeanDefinition(FahrscheinNakadiConsumer.class).addConstructorArgReference(this.registerNakadiClient((AbstractConfig)consumerConfig, "consumer")).addConstructorArgValue((Object)consumerConfig);
        });
    }

    private String registerPublisher(PublisherConfig publisherConfig) {
        return this.registry.registerIfAbsent(publisherConfig.getId(), NakadiPublisher.class, () -> {
            log.info("[{}] - register NakadiPublisher ...", (Object)publisherConfig.getId());
            return BeanDefinitionBuilder.genericBeanDefinition(DefaultNakadiPublisher.class).addConstructorArgReference(this.registerNakadiClient((AbstractConfig)publisherConfig, "publisher"));
        });
    }

    private String registerNakadiClient(AbstractConfig consumerConfig, String type) {
        return this.registry.registerIfAbsent(consumerConfig.getId() + "-" + type, NakadiClient.class, () -> {
            log.info("[{}] - register NakadiClient ...", (Object)consumerConfig.getId());
            return BeanDefinitionBuilder.genericBeanDefinition(FahrscheinNakadiClientFactory.class).addConstructorArgReference("fahrscheinAccessTokenProvider").addConstructorArgValue((Object)consumerConfig).setFactoryMethod("create");
        });
    }

    public FahrscheinRegistrar(Registry registry, FahrscheinConfigProperties fahrscheinConfigProperties, Environment environment) {
        this.registry = registry;
        this.fahrscheinConfigProperties = fahrscheinConfigProperties;
        this.environment = environment;
    }
}

