/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spring.boot.nakadi.config;

import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.zalando.spring.boot.nakadi.NakadiListener;
import org.zalando.spring.boot.nakadi.config.NakadiConsumer;

class NakadiListenerContainer
implements SmartLifecycle,
BeanNameAware {
    private static final Logger log = LoggerFactory.getLogger(NakadiListenerContainer.class);
    private ThreadPoolTaskScheduler scheduler;
    private AtomicReference<ScheduledFuture<?>> scheduledTaskReference = new AtomicReference();
    private Boolean autoStartup = true;
    private String beanName = "BEAN_NAME_NOT_SET";
    @NonNull
    private final NakadiConsumer nakadiConsumer;
    @NonNull
    private final NakadiListener<?> nakadiListener;

    public synchronized void initialize() {
        if (this.scheduler == null) {
            this.scheduler = new ThreadPoolTaskScheduler();
            this.scheduler.setWaitForTasksToCompleteOnShutdown(false);
            this.scheduler.setPoolSize(5);
            this.scheduler.setThreadFactory(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new NakadiListenerThread(r, NakadiListenerContainer.this.beanName);
                }
            });
            this.scheduler.setBeanName("taskScheduler-" + this.beanName);
            this.scheduler.afterPropertiesSet();
        }
    }

    public void start() {
        log.info("Starting NakadiListener {} ...", (Object)this.beanName);
        if (this.isRunning()) {
            log.info("... NakadiListener {} is already running", (Object)this.beanName);
            return;
        }
        this.initialize();
        try {
            this.scheduledTaskReference.set(this.scheduler.scheduleAtFixedRate(this.nakadiConsumer.runnable(this.nakadiListener).unchecked(), 70000L));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("unable to start nakadi-listener " + this.beanName, e);
        }
        log.info("... started NakadiListener {}", (Object)this.beanName);
    }

    public void stop() {
        log.info("Stopping NakadiListener ...");
        if (!this.isRunning()) {
            log.info("... NakadiListener not running.");
            return;
        }
        ScheduledFuture<?> sf = this.scheduledTaskReference.get();
        if (sf != null) {
            sf.cancel(true);
        }
        this.scheduler.shutdown();
        this.scheduler = null;
        log.info("... stopped NakadiListener {}", (Object)this.beanName);
    }

    public boolean isRunning() {
        ScheduledFuture<?> sf = this.scheduledTaskReference.get();
        if (sf == null) {
            return false;
        }
        return !sf.isDone() && !sf.isCancelled();
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    NakadiListenerContainer(@NonNull NakadiConsumer nakadiConsumer, @NonNull NakadiListener<?> nakadiListener) {
        if (nakadiConsumer == null) {
            throw new NullPointerException("nakadiConsumer is marked non-null but is null");
        }
        if (nakadiListener == null) {
            throw new NullPointerException("nakadiListener is marked non-null but is null");
        }
        this.nakadiConsumer = nakadiConsumer;
        this.nakadiListener = nakadiListener;
    }

    static class NakadiListenerThread
    extends Thread {
        NakadiListenerThread(Runnable target, String name) {
            super(target, name);
            this.setDaemon(true);
        }
    }
}

