/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spring.boot.nakadi.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.fahrschein.AccessTokenProvider;
import org.zalando.fahrschein.CursorManager;
import org.zalando.fahrschein.NakadiClient;
import org.zalando.fahrschein.NakadiClientBuilder;
import org.zalando.fahrschein.http.api.RequestFactory;
import org.zalando.spring.boot.nakadi.config.properties.AbstractConfig;

class FahrscheinNakadiClientFactory {
    private static final Logger log = LoggerFactory.getLogger(FahrscheinNakadiClientFactory.class);

    FahrscheinNakadiClientFactory() {
    }

    static NakadiClient create(AccessTokenProvider accessTokenProvider, AbstractConfig config, CursorManager cursorManager, ObjectMapper objectMapper, RequestFactory requestFactory) {
        NakadiClientBuilder ncb = NakadiClient.builder((URI)URI.create(config.getNakadiUrl())).withRequestFactory(requestFactory).withCursorManager(cursorManager).withObjectMapper(objectMapper);
        if (config.getOauth().getEnabled().booleanValue()) {
            ncb = ncb.withAccessTokenProvider(accessTokenProvider);
        } else {
            log.info("NakadiClient: [{}] - No AccessTokenProvider configured. No 'accessTokenId' was set.", (Object)config.getId());
        }
        return ncb.build();
    }
}

