/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spring.boot.nakadi.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.env.Environment;
import org.zalando.fahrschein.CursorManager;
import org.zalando.fahrschein.NakadiClient;
import org.zalando.fahrschein.http.api.RequestFactory;
import org.zalando.spring.boot.config.Registry;
import org.zalando.spring.boot.nakadi.NakadiPublisher;
import org.zalando.spring.boot.nakadi.config.CursorManagerFactory;
import org.zalando.spring.boot.nakadi.config.DefaultNakadiPublisher;
import org.zalando.spring.boot.nakadi.config.FahrscheinNakadiClientFactory;
import org.zalando.spring.boot.nakadi.config.FahrscheinNakadiConsumer;
import org.zalando.spring.boot.nakadi.config.NakadiClientsRegistrar;
import org.zalando.spring.boot.nakadi.config.NakadiConsumer;
import org.zalando.spring.boot.nakadi.config.NakadiListenerContainer;
import org.zalando.spring.boot.nakadi.config.ObjectMapperFactory;
import org.zalando.spring.boot.nakadi.config.RequestFactoryFactory;
import org.zalando.spring.boot.nakadi.config.properties.AbstractConfig;
import org.zalando.spring.boot.nakadi.config.properties.ConsumerConfig;
import org.zalando.spring.boot.nakadi.config.properties.FahrscheinConfigProperties;
import org.zalando.spring.boot.nakadi.config.properties.PublisherConfig;

public class FahrscheinRegistrar
implements NakadiClientsRegistrar {
    private static final Logger log = LoggerFactory.getLogger(FahrscheinRegistrar.class);
    private static final String CREATE = "create";
    private static final String LOG_PREFIX = "[{}] - register ";
    private final Registry registry;
    private final FahrscheinConfigProperties fahrscheinConfigProperties;
    private final Environment environment;

    @Override
    public void register() {
        this.fahrscheinConfigProperties.getConsumers().forEach((consumerId, consumerConfig) -> {
            this.registerNakadiListenerContainer((ConsumerConfig)consumerConfig);
            log.info("[{}] - Consumer registered", (Object)consumerConfig.getId());
        });
        this.registerPublisher(this.fahrscheinConfigProperties.getPublisher());
    }

    private String registerNakadiListenerContainer(ConsumerConfig consumerConfig) {
        return this.registry.registerIfAbsent(consumerConfig.getId(), NakadiListenerContainer.class, () -> {
            log.info("[{}] - register NakadiListenerContainer ...", (Object)consumerConfig.getId());
            return BeanDefinitionBuilder.genericBeanDefinition(NakadiListenerContainer.class).addConstructorArgReference(this.registerNakadiConsumer(consumerConfig)).addConstructorArgReference(consumerConfig.getId() + "NakadiListener").addPropertyValue("autoStartup", (Object)consumerConfig.getAutostartEnabled());
        });
    }

    private String registerNakadiConsumer(ConsumerConfig consumerConfig) {
        return this.registry.registerIfAbsent(consumerConfig.getId(), NakadiConsumer.class, () -> {
            log.info("[{}] - register NakadiConsumer ...", (Object)consumerConfig.getId());
            return BeanDefinitionBuilder.genericBeanDefinition(FahrscheinNakadiConsumer.class).addConstructorArgReference(this.registerNakadiClient((AbstractConfig)consumerConfig, "consumer")).addConstructorArgValue((Object)consumerConfig);
        });
    }

    private String registerPublisher(PublisherConfig publisherConfig) {
        return this.registry.registerIfAbsent(publisherConfig.getId(), NakadiPublisher.class, () -> {
            log.info("[{}] - register NakadiPublisher ...", (Object)publisherConfig.getId());
            return BeanDefinitionBuilder.genericBeanDefinition(DefaultNakadiPublisher.class).addConstructorArgReference(this.registerNakadiClient((AbstractConfig)publisherConfig, "publisher"));
        });
    }

    private String registerNakadiClient(AbstractConfig consumerConfig, String type) {
        return this.registry.registerIfAbsent(consumerConfig.getId() + "-" + type, NakadiClient.class, () -> {
            log.info("[{}] - register NakadiClient ...", (Object)consumerConfig.getId());
            String requestFactoryRef = this.registerRequestFactory(consumerConfig);
            return BeanDefinitionBuilder.genericBeanDefinition(FahrscheinNakadiClientFactory.class).addConstructorArgReference("fahrscheinAccessTokenProvider").addConstructorArgValue((Object)consumerConfig).addConstructorArgReference(this.registerCursorManager(consumerConfig, requestFactoryRef)).addConstructorArgReference(this.registerObjectMapper(consumerConfig)).addConstructorArgReference(requestFactoryRef).setFactoryMethod(CREATE);
        });
    }

    private String registerRequestFactory(AbstractConfig consumerConfig) {
        return this.registry.registerIfAbsent(consumerConfig.getId(), RequestFactory.class, () -> {
            log.info("[{}] - register RequestFactory ...", (Object)consumerConfig.getId());
            return BeanDefinitionBuilder.genericBeanDefinition(RequestFactoryFactory.class).addConstructorArgValue((Object)consumerConfig).setFactoryMethod(CREATE);
        });
    }

    private String registerObjectMapper(AbstractConfig consumerConfig) {
        return this.registry.registerIfAbsent(consumerConfig.getId(), ObjectMapper.class, () -> {
            log.info("[{}] - register ObjectMapper ...", (Object)consumerConfig.getId());
            return BeanDefinitionBuilder.genericBeanDefinition(ObjectMapperFactory.class).setFactoryMethod(CREATE);
        });
    }

    private String registerCursorManager(AbstractConfig consumerConfig, String requestFactoryRef) {
        return this.registry.registerIfAbsent("", CursorManager.class, () -> {
            log.info("[{}] - register CursorManager ...", (Object)consumerConfig.getId());
            return BeanDefinitionBuilder.genericBeanDefinition(CursorManagerFactory.class).addConstructorArgValue((Object)consumerConfig).addConstructorArgReference(requestFactoryRef).setFactoryMethod(CREATE);
        });
    }

    public FahrscheinRegistrar(Registry registry, FahrscheinConfigProperties fahrscheinConfigProperties, Environment environment) {
        this.registry = registry;
        this.fahrscheinConfigProperties = fahrscheinConfigProperties;
        this.environment = environment;
    }
}

