/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spring.boot.nakadi.config;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.util.Assert;
import org.zalando.fahrschein.MetricsCollector;

public class MicrometerMetricsCollector
implements MetricsCollector {
    private static final String MESSAGES_SUCCESSFULLY_PROCESSED = ".messages.successfully.processed";
    private static final String RECONNECTIONS = ".reconnections";
    private static final String ERRORS_WHILE_CONSUMING = ".errors.while.consuming";
    private static final String EVENTS_RECEIVED = ".events.received";
    private static final String MESSAGES_RECEIVED = ".messages.received";
    private static final String PREFIX = "fahrschein.listener.";
    private final Counter messagesReceivedMeter;
    private final Counter eventsReceivedMeter;
    private final Counter errorsWhileConsumingMeter;
    private final Counter reconnectionsMeter;
    private final Counter messagesSuccessfullyProcessedMeter;

    public MicrometerMetricsCollector(MeterRegistry meterRegistry, String id) {
        Assert.notNull((Object)meterRegistry, (String)"'meterRegistry' should never be null");
        Assert.hasText((String)id, (String)"'id' should never be null or empty");
        this.messagesReceivedMeter = meterRegistry.counter(PREFIX + id + MESSAGES_RECEIVED, new String[0]);
        this.eventsReceivedMeter = meterRegistry.counter(PREFIX + id + EVENTS_RECEIVED, new String[0]);
        this.errorsWhileConsumingMeter = meterRegistry.counter(PREFIX + id + ERRORS_WHILE_CONSUMING, new String[0]);
        this.reconnectionsMeter = meterRegistry.counter(PREFIX + id + RECONNECTIONS, new String[0]);
        this.messagesSuccessfullyProcessedMeter = meterRegistry.counter(PREFIX + id + MESSAGES_SUCCESSFULLY_PROCESSED, new String[0]);
    }

    public void markMessageReceived() {
        this.messagesReceivedMeter.increment();
    }

    public void markEventsReceived(int size) {
        this.eventsReceivedMeter.increment((double)size);
    }

    public void markErrorWhileConsuming() {
        this.errorsWhileConsumingMeter.increment();
    }

    public void markReconnection() {
        this.reconnectionsMeter.increment();
    }

    public void markMessageSuccessfullyProcessed() {
        this.messagesSuccessfullyProcessedMeter.increment();
    }
}

