/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spring.boot.nakadi.config;

import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.zalando.fahrschein.http.apache.HttpComponentsRequestFactory;
import org.zalando.fahrschein.http.api.RequestFactory;
import org.zalando.spring.boot.nakadi.config.properties.AbstractConfig;
import org.zalando.spring.boot.nakadi.config.properties.HttpConfig;

class RequestFactoryFactory {
    RequestFactoryFactory() {
    }

    static RequestFactory create(AbstractConfig config) {
        CloseableHttpClient closeableHttpClient = RequestFactoryFactory.buildCloseableHttpClient(config.getHttp());
        return new HttpComponentsRequestFactory((HttpClient)closeableHttpClient);
    }

    protected static CloseableHttpClient buildCloseableHttpClient(HttpConfig httpConfig) {
        RequestConfig config = RequestConfig.custom().setSocketTimeout((int)TimeUnit.MILLISECONDS.convert(httpConfig.getSocketTimeout().getAmount(), httpConfig.getSocketTimeout().getUnit())).setConnectTimeout((int)TimeUnit.MILLISECONDS.convert(httpConfig.getConnectTimeout().getAmount(), httpConfig.getConnectTimeout().getUnit())).setConnectionRequestTimeout((int)TimeUnit.MILLISECONDS.convert(httpConfig.getConnectionRequestTimeout().getAmount(), httpConfig.getConnectionRequestTimeout().getUnit())).build();
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setBufferSize(httpConfig.getBufferSize().intValue()).build();
        HttpClientBuilder builder = HttpClients.custom().setDefaultRequestConfig(config).setDefaultConnectionConfig(connectionConfig).setConnectionTimeToLive(httpConfig.getConnectionTimeToLive().getAmount(), httpConfig.getConnectionTimeToLive().getUnit()).disableAutomaticRetries().disableRedirectHandling().setMaxConnTotal(httpConfig.getMaxConnectionsTotal().intValue()).setMaxConnPerRoute(httpConfig.getMaxConnectionsPerRoute().intValue());
        if (httpConfig.getEvictExpiredConnections().booleanValue()) {
            builder = builder.evictExpiredConnections();
        }
        if (httpConfig.getEvictIdleConnections().booleanValue()) {
            builder = builder.evictIdleConnections(httpConfig.getMaxIdleTime().longValue(), TimeUnit.MILLISECONDS);
        }
        return builder.build();
    }
}

