/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spring.boot.nakadi.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.zalando.spring.boot.config.Registry;
import org.zalando.spring.boot.nakadi.config.DefaultNakadiClientsRegistrar;
import org.zalando.spring.boot.nakadi.config.NakadiClientsProperties;
import org.zalando.spring.boot.nakadi.config.SettingsParser;
import org.zalando.stups.tokens.AccessTokens;

public class NakadiClientsPostProcessor
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private final AccessTokens accessTokens;
    private NakadiClientsProperties properties;

    public void setEnvironment(Environment environment) {
        ArrayList parsers = Lists.newArrayList(ServiceLoader.load(SettingsParser.class));
        this.properties = this.parse((ConfigurableEnvironment)environment, parsers);
    }

    NakadiClientsProperties parse(ConfigurableEnvironment environment, Collection<SettingsParser> parsers) {
        SettingsParser parser = parsers.stream().filter(SettingsParser::isApplicable).findFirst().orElseThrow(() -> new NoSuchElementException("No applicable nakadi-clients settings parser available"));
        return parser.parse(environment);
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        DefaultNakadiClientsRegistrar registrar = new DefaultNakadiClientsRegistrar(new Registry(registry), this.properties, this.accessTokens);
        registrar.register();
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public NakadiClientsPostProcessor(AccessTokens accessTokens) {
        this.accessTokens = accessTokens;
    }
}

