/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spring.boot.nakadi.config;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.zalando.fahrschein.AccessTokenProvider;
import org.zalando.fahrschein.NakadiClient;
import org.zalando.spring.boot.config.Registry;
import org.zalando.spring.boot.nakadi.NakadiConsumer;
import org.zalando.spring.boot.nakadi.NakadiPublisher;
import org.zalando.spring.boot.nakadi.config.DefaultNakadiConsumer;
import org.zalando.spring.boot.nakadi.config.DefaultNakadiPublisher;
import org.zalando.spring.boot.nakadi.config.NakadiClientFactory;
import org.zalando.spring.boot.nakadi.config.NakadiClientsProperties;
import org.zalando.spring.boot.nakadi.config.NakadiClientsRegistrar;
import org.zalando.spring.boot.nakadi.config.NakadiListenerContainer;
import org.zalando.stups.tokens.AccessTokens;

public class DefaultNakadiClientsRegistrar
implements NakadiClientsRegistrar {
    private static final Logger log = LoggerFactory.getLogger(DefaultNakadiClientsRegistrar.class);
    private final Registry registry;
    private final NakadiClientsProperties properties;
    private final AccessTokens accessTokens;
    private AccessTokenProvider noopAccessTokenProvider = new AccessTokenProvider(){

        public String getAccessToken() throws IOException {
            return "NOOP_ACCESS_TOKEN";
        }
    };

    @Override
    public void register() {
        this.properties.getClients().forEach((clientId, client) -> {
            String registeredClientId = this.registerNakadiClient((String)clientId, (NakadiClientsProperties.Client)client);
            client.getConsumers().forEach((consumerId, nakadiConsumerConfig) -> {
                String consumerIdentifier = this.registerConsumer(registeredClientId, (String)consumerId, (NakadiClientsProperties.Client.NakadiConsumerConfig)nakadiConsumerConfig, client.getDefaults());
                String nakadiListenerContainerId = this.registerNakadiListenerContainer(consumerIdentifier, (String)consumerId, (NakadiClientsProperties.Client.NakadiConsumerConfig)nakadiConsumerConfig);
                log.info("Registered consumer : {} and listenerContainer : {}", (Object)consumerIdentifier, (Object)nakadiListenerContainerId);
            });
            client.getPublishers().stream().forEach(publisherId -> this.registerPublisher(registeredClientId, (String)publisherId));
        });
    }

    private String registerNakadiClient(String id, NakadiClientsProperties.Client client) {
        return this.registry.registerIfAbsent(id, NakadiClient.class, () -> {
            log.info("NakadiClient: [{}] registered", (Object)id);
            return BeanDefinitionBuilder.genericBeanDefinition(NakadiClientFactory.class).addConstructorArgValue((Object)this.buildAccessTokenProvider(client.getAccessTokenId())).addConstructorArgValue((Object)client).addConstructorArgValue((Object)id).setFactoryMethod("create");
        });
    }

    private String registerConsumer(String nakadiClientId, String listenerId, NakadiClientsProperties.Client.NakadiConsumerConfig consumerConfig, NakadiClientsProperties.Client.NakadiConsumerDefaults consumerDefaults) {
        return this.registry.registerIfAbsent(listenerId, NakadiConsumer.class, () -> {
            log.info("NakadiConsumer: [{}] registered with NakadiClient: [{}]", (Object)listenerId, (Object)nakadiClientId);
            return BeanDefinitionBuilder.genericBeanDefinition(DefaultNakadiConsumer.class).addConstructorArgReference(nakadiClientId).addConstructorArgValue((Object)consumerConfig).addConstructorArgValue((Object)consumerDefaults);
        });
    }

    private String registerNakadiListenerContainer(String nakadiConsumerId, String listenerPrefix, NakadiClientsProperties.Client.NakadiConsumerConfig consumerConfig) {
        return this.registry.registerIfAbsent(nakadiConsumerId + "ListenerContainer", NakadiListenerContainer.class, () -> {
            log.info("NakadiListenerContainer: [{}] registered with NakadiConsumer: [{}]", (Object)(nakadiConsumerId + "ListenerContainer"), (Object)nakadiConsumerId);
            return BeanDefinitionBuilder.genericBeanDefinition(NakadiListenerContainer.class).addConstructorArgReference(nakadiConsumerId).addConstructorArgReference(listenerPrefix + "NakadiListener").addPropertyValue("autoStartup", (Object)consumerConfig.isAutostartEnabled());
        });
    }

    private String registerPublisher(String nakadiClientId, String publisherId) {
        return this.registry.registerIfAbsent(publisherId, NakadiPublisher.class, () -> {
            log.info("NakadiPublisher: [{}] registered with NakadiClient: [{}]", (Object)publisherId, (Object)nakadiClientId);
            return BeanDefinitionBuilder.genericBeanDefinition(DefaultNakadiPublisher.class).addConstructorArgReference(nakadiClientId);
        });
    }

    protected AccessTokenProvider buildAccessTokenProvider(final String accessTokenId) {
        return accessTokenId == null ? this.noopAccessTokenProvider : new AccessTokenProvider(){

            public String getAccessToken() throws IOException {
                return DefaultNakadiClientsRegistrar.this.accessTokens.get((Object)accessTokenId);
            }
        };
    }

    public DefaultNakadiClientsRegistrar(Registry registry, NakadiClientsProperties properties, AccessTokens accessTokens) {
        this.registry = registry;
        this.properties = properties;
        this.accessTokens = accessTokens;
    }
}

