/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spring.boot.nakadi.config;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.zalando.spring.boot.nakadi.NakadiConsumer;
import org.zalando.spring.boot.nakadi.NakadiListener;

class NakadiListenerContainer
implements SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(NakadiListenerContainer.class);
    private static final AtomicInteger containerCounter = new AtomicInteger();
    private final ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
    private AtomicReference<ScheduledFuture<?>> scheduledTaskReference = new AtomicReference();
    private int containerNumber = -1;
    private boolean autoStartup = true;
    @NonNull
    private final NakadiConsumer nakadiConsumer;
    @NonNull
    private final NakadiListener<?> nakadiListener;

    @PostConstruct
    public void initialize() {
        this.containerNumber = containerCounter.incrementAndGet();
        this.scheduler.setPoolSize(1);
        this.scheduler.setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new NakadiListenerThread(r, "nakadiListener-" + NakadiListenerContainer.this.containerNumber);
            }
        });
        this.scheduler.afterPropertiesSet();
    }

    public void start() {
        log.info("Starting NakadiListener ...");
        if (this.isRunning()) {
            log.info("... NakadiListener is already running");
            return;
        }
        try {
            this.scheduledTaskReference.set(this.scheduler.scheduleAtFixedRate(this.nakadiConsumer.runnable(this.nakadiListener).unchecked(), Duration.ofSeconds(6L)));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("unable to start nakadi-listener", e);
        }
        log.info("... started NakadiListener");
    }

    public void stop() {
        log.info("Stopping NakadiListener ...");
        if (!this.isRunning()) {
            log.info("... NakadiListener not running.");
            return;
        }
        ScheduledFuture<?> sf = this.scheduledTaskReference.get();
        if (sf != null) {
            sf.cancel(true);
        }
        this.scheduler.shutdown();
        log.info("... stopped NakadiListener");
    }

    public boolean isRunning() {
        ScheduledFuture<?> sf = this.scheduledTaskReference.get();
        if (sf == null) {
            return false;
        }
        return !sf.isDone() && !sf.isCancelled();
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    NakadiListenerContainer(@NonNull NakadiConsumer nakadiConsumer, @NonNull NakadiListener<?> nakadiListener) {
        if (nakadiConsumer == null) {
            throw new NullPointerException("nakadiConsumer is marked non-null but is null");
        }
        if (nakadiListener == null) {
            throw new NullPointerException("nakadiListener is marked non-null but is null");
        }
        this.nakadiConsumer = nakadiConsumer;
        this.nakadiListener = nakadiListener;
    }

    static class NakadiListenerThread
    extends Thread {
        NakadiListenerThread(Runnable target, String name) {
            super(target, name);
            this.setDaemon(true);
        }
    }
}

