/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spring.boot.nakadi.config;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.zalando.fahrschein.AuthorizationBuilder;
import org.zalando.fahrschein.IORunnable;
import org.zalando.fahrschein.NakadiClient;
import org.zalando.fahrschein.StreamParameters;
import org.zalando.fahrschein.SubscriptionBuilder;
import org.zalando.fahrschein.domain.Authorization;
import org.zalando.fahrschein.domain.Subscription;
import org.zalando.spring.boot.nakadi.NakadiListener;
import org.zalando.spring.boot.nakadi.config.ConsumerConfig;
import org.zalando.spring.boot.nakadi.config.NakadiConsumer;
import org.zalando.spring.boot.nakadi.config.Position;
import org.zalando.spring.boot.nakadi.config.StreamParametersConfig;

public class FahrscheinNakadiConsumer
implements NakadiConsumer,
BeanNameAware,
ApplicationEventPublisherAware {
    private final NakadiClient nakadiClient;
    private final ConsumerConfig consumerConfig;
    private String beanName;
    private ApplicationEventPublisher eventPublisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    @Override
    public <Type> IORunnable runnable(NakadiListener<Type> listener) throws IOException {
        Subscription sub = this.getSubscription();
        StreamParameters streamParams = this.getStreamParameters();
        IORunnable result = this.nakadiClient.stream(sub).withStreamParameters(streamParams).runnable(listener.getEventType(), listener);
        return result;
    }

    private Subscription getSubscription() throws IOException {
        SubscriptionBuilder sb = this.nakadiClient.subscription(this.consumerConfig.getApplicationName(), (Set)Sets.newHashSet((Iterable)this.consumerConfig.getTopics())).withConsumerGroup(this.consumerConfig.getConsumerGroup()).withAuthorization(AuthorizationBuilder.authorization().withReaders(new Authorization.AuthorizationAttribute[]{Authorization.AuthorizationAttribute.ANYONE}).addAdmin("user", "me").build());
        sb = Position.END.equals((Object)this.consumerConfig.getReadFrom()) ? sb.readFromEnd() : sb.readFromBegin();
        return sb.subscribe();
    }

    protected StreamParameters getStreamParameters() {
        if (this.consumerConfig.getStreamParameters() == null) {
            return new StreamParameters();
        }
        StreamParametersConfig config = this.consumerConfig.getStreamParameters();
        StreamParameters sp = new StreamParameters();
        if (config.getBatchFlushTimeout() != null) {
            sp = sp.withBatchFlushTimeout(config.getBatchFlushTimeout().intValue());
        }
        if (config.getBatchLimit() != null) {
            sp = sp.withBatchLimit(config.getBatchLimit().intValue());
        }
        if (config.getMaxUncommittedEvents() != null) {
            sp = sp.withMaxUncommittedEvents(config.getMaxUncommittedEvents().intValue());
        }
        if (config.getStreamKeepAliveLimit() != null) {
            sp = sp.withStreamKeepAliveLimit(config.getStreamKeepAliveLimit().intValue());
        }
        if (config.getStreamLimit() != null) {
            sp = sp.withStreamLimit(config.getStreamLimit().intValue());
        }
        if (config.getStreamTimeout() != null) {
            sp = sp.withStreamTimeout(config.getStreamTimeout().intValue());
        }
        return sp;
    }

    public FahrscheinNakadiConsumer(NakadiClient nakadiClient, ConsumerConfig consumerConfig) {
        this.nakadiClient = nakadiClient;
        this.consumerConfig = consumerConfig;
    }
}

