/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spring.k8s;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

@Endpoint(id="preStop")
public class PreStopHealthIndicator
extends AbstractHealthIndicator {
    private static final Logger log = LoggerFactory.getLogger(PreStopHealthIndicator.class);
    private static final int DEFAULT_TIMEOUT = 26;
    private Status status = Status.UP;

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        builder.status(this.status);
    }

    @ReadOperation
    public Map<String, String> invokePrestop() {
        return this.invokePrestopInternal(26);
    }

    @ReadOperation
    public Map<String, String> invokePrestopWithTime(@Selector int time) {
        return this.invokePrestopInternal(time);
    }

    protected Map<String, String> invokePrestopInternal(int time) {
        try {
            this.status = Status.OUT_OF_SERVICE;
            log.debug("STATUS SWITCHED TO '{}', SLEEP FOR '{}' SECONDS  ...", (Object)this.status.getCode(), (Object)time);
            TimeUnit.SECONDS.sleep(time);
            log.debug("AFTER SLEEPING ...");
        }
        catch (InterruptedException e) {
            log.warn("preStop interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return Collections.singletonMap("status", this.status.getCode());
    }
}

