/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spring.data.businesskey.config;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.util.Assert;
import org.zalando.spring.data.businesskey.annotation.BusinessKey;

final class AnnotationBusinessKeyMetadata {
    private static final ReflectionUtils.AnnotationFieldFilter BUSINESSKEY_FILTER = new ReflectionUtils.AnnotationFieldFilter(BusinessKey.class);
    private static final Map<Class<?>, AnnotationBusinessKeyMetadata> METADATACACHE = new ConcurrentHashMap();
    private final Field businessKeyField;

    private AnnotationBusinessKeyMetadata(Class<?> type) {
        Assert.notNull(type, (String)"Given Type must not be null");
        this.businessKeyField = ReflectionUtils.findField(type, (ReflectionUtils.DescribedFieldFilter)BUSINESSKEY_FILTER);
    }

    public static AnnotationBusinessKeyMetadata getMetadata(Class<?> type) {
        if (METADATACACHE.containsKey(type)) {
            return METADATACACHE.get(type);
        }
        AnnotationBusinessKeyMetadata metadata = new AnnotationBusinessKeyMetadata(type);
        METADATACACHE.put(type, metadata);
        return metadata;
    }

    public boolean isKeyable() {
        return this.businessKeyField != null;
    }

    public Field getKeyField() {
        return this.businessKeyField;
    }
}

