/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spring.data.businesskey.config;

import java.lang.annotation.Annotation;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.aop.target.LazyInitTargetSource;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.zalando.spring.data.businesskey.config.AnnotationBusinessKeyConfiguration;
import org.zalando.spring.data.businesskey.config.BusinessKeyConfiguration;
import org.zalando.spring.data.businesskey.config.BusinessKeyHandler;

public abstract class BusinessKeyBeanDefinitionRegistrarSupport
implements ImportBeanDefinitionRegistrar {
    private static final String KEYGENERATOR = "keyGenerator";

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry beanDefinitionRegistry) {
        Assert.notNull((Object)annotationMetadata, (String)"AnnotationMetadata must not be null");
        Assert.notNull((Object)beanDefinitionRegistry, (String)"BeanDefinitionRegistry must not be null");
        AbstractBeanDefinition khbd = this.getKeyHandlerBeanDefinitionBuilder(beanDefinitionRegistry, this.getConfiguration(annotationMetadata));
        this.registerBusinessKeyListenerBeanDefinition(khbd, beanDefinitionRegistry);
    }

    protected abstract void registerBusinessKeyListenerBeanDefinition(AbstractBeanDefinition var1, BeanDefinitionRegistry var2);

    protected AbstractBeanDefinition getKeyHandlerBeanDefinitionBuilder(BeanDefinitionRegistry beanDefinitionRegistry, BusinessKeyConfiguration configuration) {
        Assert.notNull((Object)beanDefinitionRegistry, (String)"BeanDefinitionRegistry must not be null");
        Assert.notNull((Object)configuration, (String)"BusinessKeyConfiguration must not be null");
        AbstractBeanDefinition khbd = this.getBusinessKeyBeanDefinitionBuilder(configuration).getBeanDefinition();
        beanDefinitionRegistry.registerBeanDefinition(this.getBusinessKeyHandlerBeanName(), (BeanDefinition)khbd);
        return khbd;
    }

    protected BeanDefinitionBuilder getBusinessKeyBeanDefinitionBuilder(BusinessKeyConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"BusinessKeyConfiguration must not be null");
        return this.configureDefaultBusinessKeyHandlerAttributes(configuration, BeanDefinitionBuilder.rootBeanDefinition(BusinessKeyHandler.class));
    }

    private BeanDefinitionBuilder configureDefaultBusinessKeyHandlerAttributes(BusinessKeyConfiguration configuration, BeanDefinitionBuilder builder) {
        if (StringUtils.hasText((String)configuration.getBusinessKeyAwareRef())) {
            builder.addPropertyValue(KEYGENERATOR, (Object)this.createLazyInitTargetSourceBeanDefinition(configuration.getBusinessKeyAwareRef()));
        } else {
            builder.setAutowireMode(2);
        }
        builder.setRole(2);
        return builder;
    }

    private BeanDefinition createLazyInitTargetSourceBeanDefinition(String businessKeyAwareRef) {
        BeanDefinitionBuilder targetSourceBuilder = BeanDefinitionBuilder.rootBeanDefinition(LazyInitTargetSource.class);
        targetSourceBuilder.addPropertyValue("targetBeanName", (Object)businessKeyAwareRef);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ProxyFactoryBean.class);
        builder.addPropertyValue("targetSource", (Object)targetSourceBuilder.getBeanDefinition());
        return builder.getBeanDefinition();
    }

    private BusinessKeyConfiguration getConfiguration(AnnotationMetadata annotationMetadata) {
        return new AnnotationBusinessKeyConfiguration(annotationMetadata, this.getAnnotation());
    }

    protected void registerInfrastructureBeanWithId(AbstractBeanDefinition definition, String id, BeanDefinitionRegistry registry) {
        definition.setRole(2);
        registry.registerBeanDefinition(id, (BeanDefinition)definition);
    }

    protected abstract Class<? extends Annotation> getAnnotation();

    protected abstract String getBusinessKeyHandlerBeanName();
}

