/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spring.data.businesskey.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.util.ReflectionUtils;
import org.zalando.spring.data.businesskey.annotation.BusinessKey;
import org.zalando.spring.data.businesskey.config.AnnotationBusinessKeyMetadata;
import org.zalando.spring.data.businesskey.config.BusinessKeyBeanWrapper;

public class BusinessKeyBeanWrapperFactory {
    BusinessKeyBeanWrapper getBeanWrapperFor(Object source) {
        if (source == null) {
            return null;
        }
        AnnotationBusinessKeyMetadata metadata = AnnotationBusinessKeyMetadata.getMetadata(source.getClass());
        if (metadata.isKeyable()) {
            return new ReflectionKeyableBeanWrapper(source);
        }
        return null;
    }

    static class ReflectionKeyableBeanWrapper
    implements BusinessKeyBeanWrapper {
        private final Object source;
        private final AnnotationBusinessKeyMetadata metadata;

        ReflectionKeyableBeanWrapper(Object source) {
            this.source = source;
            this.metadata = AnnotationBusinessKeyMetadata.getMetadata(source.getClass());
        }

        @Override
        public String getBusinessKeySelector() {
            BusinessKey keyAnnotation = this.metadata.getKeyField().getAnnotation(BusinessKey.class);
            return (String)AnnotationUtils.getValue((Annotation)keyAnnotation, (String)"value");
        }

        @Override
        public void setBusinessKey(Object key) {
            this.setField(this.metadata.getKeyField(), key);
        }

        private void setField(Field keyField, Object key) {
            if (keyField != null) {
                ReflectionUtils.setField((Field)keyField, (Object)this.source, (Object)key);
            }
        }
    }
}

