/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spring.data.businesskey.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.zalando.spring.data.businesskey.BusinessKeyGenerator;
import org.zalando.spring.data.businesskey.config.BusinessKeyBeanWrapper;
import org.zalando.spring.data.businesskey.config.BusinessKeyBeanWrapperFactory;

public class BusinessKeyHandler
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusinessKeyHandler.class);
    private final BusinessKeyBeanWrapperFactory factory = new BusinessKeyBeanWrapperFactory();
    private BusinessKeyGenerator keyGenerator;

    public void setKeyGenerator(BusinessKeyGenerator keygenerator) {
        Assert.notNull((Object)keygenerator);
        this.keyGenerator = keygenerator;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.keyGenerator == null) {
            LOGGER.warn("No KeyGenerator set! Keying will not be applied!");
        }
    }

    public void markCreated(Object target) {
        this.touchCreated(target);
    }

    private void touchCreated(Object target) {
        BusinessKeyBeanWrapper wrapper = this.factory.getBeanWrapperFor(target);
        if (wrapper != null) {
            Object key = this.keyGenerator.getBusinessKeyForSelector(wrapper.getBusinessKeySelector());
            wrapper.setBusinessKey(key);
        }
    }
}

