/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spring.data.businesskey.config;

import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.aop.target.LazyInitTargetSource;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.zalando.spring.data.businesskey.config.BusinessKeyHandler;

public class BusinessKeyHandlerBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String BUSINESSKEY_GENERATOR_REF = "businesskey-generator-ref";

    protected Class<?> getBeanClass(Element element) {
        return BusinessKeyHandler.class;
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        String keyGeneratorRef = element.getAttribute(BUSINESSKEY_GENERATOR_REF);
        if (StringUtils.hasText((String)keyGeneratorRef)) {
            builder.addPropertyValue("keyGenerator", (Object)this.createLazyInitTargetSourceBeanDefinition(keyGeneratorRef));
        }
    }

    private BeanDefinition createLazyInitTargetSourceBeanDefinition(String keyGeneratorRef) {
        BeanDefinitionBuilder targetSourceBuilder = BeanDefinitionBuilder.rootBeanDefinition(LazyInitTargetSource.class);
        targetSourceBuilder.addPropertyValue("targetBeanName", (Object)keyGeneratorRef);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ProxyFactoryBean.class);
        builder.addPropertyValue("targetSource", (Object)targetSourceBuilder.getBeanDefinition());
        return builder.getBeanDefinition();
    }
}

