/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.spring.data.businesskey.jpa.config;

import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.aop.target.LazyInitTargetSource;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.zalando.spring.data.businesskey.config.BusinessKeyHandler;

public class JpaBusinessKeyRegistrar
implements ImportBeanDefinitionRegistrar {
    static final String KEY_ENTITY_LISTENER_CLASS_NAME = "org.zalando.spring.data.businesskey.jpa.BusinessKeyEntityListener";
    private static final String KEY_BFPP_CLASS_NAME = "org.zalando.spring.data.businesskey.config.BusinessKeyBeanFactoryPostProcessor";
    private static final String BEAN_CONFIGURER_ASPECT_CLASS_NAME = "org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect";

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry beanDefinitionRegistry) {
        Assert.notNull((Object)annotationMetadata, (String)"AnnotationMetadata must not be null!");
        Assert.notNull((Object)beanDefinitionRegistry, (String)"BeanDefinitionRegistry must not be null!");
        this.registerBeanConfigurerAspectIfNecessary(beanDefinitionRegistry);
        BeanDefinition keyHanderBeanDefinition = this.getKeyHandlerBeanDefinition(beanDefinitionRegistry);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)KEY_ENTITY_LISTENER_CLASS_NAME);
        builder.addPropertyValue("keyHandler", (Object)keyHanderBeanDefinition);
        builder.setScope("prototype");
        this.registerInfrastructureBeanWithId(builder.getRawBeanDefinition(), KEY_ENTITY_LISTENER_CLASS_NAME, beanDefinitionRegistry);
        RootBeanDefinition def = new RootBeanDefinition(KEY_BFPP_CLASS_NAME);
        this.registerInfrastructureBeanWithId((AbstractBeanDefinition)def, KEY_BFPP_CLASS_NAME, beanDefinitionRegistry);
    }

    protected BeanDefinition getKeyHandlerBeanDefinition(BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(BusinessKeyHandler.class);
        String keyGeneratorRef = "";
        if (StringUtils.hasText((String)keyGeneratorRef)) {
            builder.addPropertyValue("keyGenerator", (Object)this.createLazyInitTargetSourceBeanDefinition(keyGeneratorRef));
        } else {
            builder.setAutowireMode(2);
        }
        builder.setRole(2);
        AbstractBeanDefinition abd = builder.getBeanDefinition();
        registry.registerBeanDefinition("keyHandler", (BeanDefinition)abd);
        return abd;
    }

    private BeanDefinition createLazyInitTargetSourceBeanDefinition(String keyGeneratorRef) {
        BeanDefinitionBuilder targetSourceBuilder = BeanDefinitionBuilder.rootBeanDefinition(LazyInitTargetSource.class);
        targetSourceBuilder.addPropertyValue("targetBeanName", (Object)keyGeneratorRef);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ProxyFactoryBean.class);
        builder.addPropertyValue("targetSource", (Object)targetSourceBuilder.getBeanDefinition());
        return builder.getBeanDefinition();
    }

    protected void registerInfrastructureBeanWithId(AbstractBeanDefinition definition, String id, BeanDefinitionRegistry registry) {
        definition.setRole(2);
        registry.registerBeanDefinition(id, (BeanDefinition)definition);
    }

    private void registerBeanConfigurerAspectIfNecessary(BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition(BEAN_CONFIGURER_ASPECT_CLASS_NAME)) {
            return;
        }
        if (!ClassUtils.isPresent((String)BEAN_CONFIGURER_ASPECT_CLASS_NAME, (ClassLoader)this.getClass().getClassLoader())) {
            throw new BeanDefinitionStoreException("org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect not found. \nCould not configure Spring Data JPA auditing-feature because spring-aspects.jar is not on the classpath!\nIf you want to use auditing please add spring-aspects.jar to the classpath.");
        }
        RootBeanDefinition def = new RootBeanDefinition();
        def.setBeanClassName(BEAN_CONFIGURER_ASPECT_CLASS_NAME);
        def.setFactoryMethodName("aspectOf");
        def.setRole(2);
        registry.registerBeanDefinition("org.springframework.context.config.internalBeanConfigurerAspect", new BeanComponentDefinition((BeanDefinition)def, "org.springframework.context.config.internalBeanConfigurerAspect").getBeanDefinition());
    }
}

